@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $gallery, $gallery->page) }}
    </section>
@endsection

@section('content')

    @include('MGCms2019::admin.partials.formErrors')
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">Reordernar {{ $gallery->name }}</h3>
        </div>
        <!-- /.box-header -->
        <div class="row">
            <div class="col-md-12">
                <div class="text-right">
                    @can('update', $gallery->page)
                    <a href="{{ route('pages.show', [$gallery->page, app()->getLocale()]) }}" class="btn btn-primary">
                        <i class="fa fas-close"></i> Finalizar
                    </a>
                    @endcan
                </div>
                <div id="gallery-items" data-route="{{ route('galleries.update', $gallery->id)}}" >
                    @foreach($gallery->items->sortBy('priority') as $key => $item)
                        <div class="item" style="background-image: url({{ $item->mediafile->path }})" data-id="{{  $item->id }}" data-priority="{{ ++$item->priority * -1 }}"></div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="box-body">
            <div class="contaner">

            </div>
        </div>
    </div>

@endsection
