@extends('MGCms2019::admin.layouts.admin')

@section('content')
    <div class="box box-default">
        <div class="box-header">
            <h3 class="box-title">Galleries</h3>
            {{-- nestable --}}
                <div class="dd model-main-tree" id="gallery" data-url="{{ route('gallery.update') }}">
                    <ol class="dd-list">
                        @foreach($galleries as $i => $gallery)
                        <li class="dd-item" data-id={{$gallery->id}}>
                             <div class="dd-handle">
                                    {{ $gallery->name }}
                                    <ul class="item-actions">
                                        @can('update', $gallery->page)
                                        <li>
                                            <a href="{{ route('gallery.show', $gallery->id) }}" class="label label-info edit"> <i class="fa fa-edit"></i></a>
                                        </li>
                                        <li>
                                            <a href="{{ route('gallery.destroy', $gallery->id) }}" class="delete-model  label label-danger delete"> <i class="fa fa-trash"></i> </a>
                                        </li>
                                        @endcan
                                    </ul>
                            </div>
                        </li>
                        @endforeach
                    </ol>
                </div>

            {{-- nestable --}}
            <div class="col-md-12 text-right">
                {{-- para habilitar el nesteable solo active el boton de reordenar
                     <button class="btn btn-info" id="reorder"><i class="fa fa-bars"></i> Reordenar</button>
                 --}}
                @can('updateFromSite', [AvengersMG\MGcms2019\App\Cms\Pages\Page::class, AvengersMG\MGcms2019\App\Cms\Sites\Site::current()])
                <a href="{{ route('gallery.create') }}" class="btn btn-primary"><i class="fa fa-plus"></i> Agregar</a>
                @endcan
            </div>
        </div>

        <div class="box-body">
            <div class="row">
                <table></table>
            </div>
        </div>
    </div>

@endsection
