@extends('MGCms2019::admin.layouts.admin')
@php
    $lang = app()->getLocale();
@endphp
@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $gallery, $gallery->page, $lang) }}
    </section>
@endsection

@section('content')

    @include('MGCms2019::admin.partials.formErrors')
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">Galer&iacute;a</h3>
        </div>
        <!-- /.box-header -->
            {!! Form::open(['route' => ['galleries.update.gallery', $gallery], 'method' => 'put', 'class' => 'gallery-form']) !!}
            <div class="form-group col-md-12 input-images">
                <div class="row">
                        <div class="form-group col-md-6">
                            <label for="name">Nombre</label>
                            <input type="text" class="form-control" name="name" value="{{ $gallery->name }}" required />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="name_es">Nombre (espa&ntilde;ol)</label>
                            <input type="text" class="form-control" name="name_es" value="{{ $gallery->name_es }}" required />
                        </div>
                    </div>
                @foreach($arr_images as $image)
                    <input type="hidden" name="images[]" id="input-media-{{ $image }}" value="{{ $image }}" />
                @endforeach
            </div>

            @can('update', $gallery->page)
            <div class="form-group col-md-12">
                <div class="form-check">
                    @php
                        /* Variables para envío de GalleryFeature de especiales */
                        $specialClass = AvengersMG\MGCms2019\App\Cms\Components\Specials\Special::class;
                        $specialChecked = in_array($specialClass, old('gallery_features', []))
                        ? true
                        : ($gallery->features()->where('featurable_type', $specialClass)->count() > 0);
                    @endphp
                    {!! Form::checkbox('gallery_features_specials', $specialClass, $specialChecked, ["class" => "form-group form-check-input", "name" => "gallery_features[]"]) !!}
                    <label class="gallery_features_specials">Inyectar im&aacute;genes de tipo &quot;header&quot; desde Especiales</label>
                    <small class="form-text text-muted">Si una imagen inyectada es eliminada de esta galer&iacute;a, esta volver&aacute; a ser inyectada por otros procesos mientras que la p&aacute;gina a la que pertenece exista y tenga estado &quot;published&quot;.</small>
                </div>
                <div class="form-check">
                    {!! Form::checkbox('gallery_is_mobile', "1", $gallery->is_mobile, ["class" => "form-group form-check-input", "name" => "is_mobile"]) !!}
                    <label class="gallery_is_mobile">Para uso en dispositivos m&oacute;viles.</label>
                    <small class="form-text text-muted">Si la inyecci&oacute;n de im&aacute;genes est&aacute; activa, solo tomar&aacute; medios de tipo &quot;header_mobile&quot;.</small>
                </div>
            </div>

            <div class="col-md-12 text-right">
                <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Galería guardada">Guardar</a>
                <button type="submit" class="btn btn-info">Guardar y cerrar</button>
            </div>

            @endcan
        {!! Form::close() !!}

        @can('update', $gallery->page)
        <div class="col-md-12 mt-5">
            {!! Form::open(['route' => 'page.upload.file', 'method' => 'POST', 'files'=> true, 'class' => 'dropzone', 'id' => 'gallery-dropzone']) !!}
            <input type="hidden" name="page" id="page" value="{{ $gallery->page_id }}" />
            <input type="hidden" name="lang" id="lang" value="{{ $lang }}" />
            <div class="fallback">
                <input name="file" type="file" multiple />
            </div>
            {!! Form::close() !!}
        </div>
        @endcan

        <div class="col-md-12 gallery-items">
            @foreach($gallery->items->sortBy('priority') as $item)
                <div class="img-choose" id="media-{{ $item->mediafile->id }}" data-action="media-action-{{ $item->mediafile->id }}" style="background-image: url({{ $item->mediafile->path }})">
                    <img src="/cms/images/delete.png" alt="" />
                </div>
            @endforeach
        </div>

        <div class="col-md-12 gallery-page-media">
            <div class="row gallery-grid selectable-media" id="extra-mediafiles">
                @foreach($mediafiles as $key => $image)
                    <div class="col-md-3">
                        <div class="media-page" style="background-image: url({{ $image->path }})">
                            <div class="media-actions {{ (in_array($image->id, $arr_images)) ? 'disabled-image' : 'add-to-gallery' }}" id="media-action-{{ $image->id }}" data-src="{{ $image->path }}" data-media="{{ $image->id }}">
                                <img src="{{ asset('cms/images/add.png') }}" alt="" />
                                <p>{{ $image->translations->implode('locale', ', ') }}</p>
                            </div>
                            <div class="selected-overlay"></div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="col-md-12 text-right">
            <a id="load-extra-mediafiles" class="btn btn-info" data-add-icon-src="{{ asset('cms/images/add.png') }}" data-load-url="{{ route('galleries.extra-mediafiles', $gallery->id) }}" data-actions-class="add-to-gallery" href="javascript:void(0);">Cargar m&aacute;s im&aacute;genes</a>
        </div>
    </div>
@endsection
