@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, app()->getLocale()) }}
    </section>
@endsection

@section('content')

@include('MGCms2019::admin.partials.formErrors')
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">Galer&iacute;a</h3>
        </div>
            <!-- /.box-header -->
        <div class="box-body">
            <div class="container">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                {!! Form::open(['route' => ['galleries.store'], 'method' => 'post', 'class' => 'gallery-form']) !!}
                <div class="form-group col-md-12 input-images">
                    <input type="hidden" name="page_id" value="{{ $page->id }}" />
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="name">Nombre</label>
                            <input type="text" class="form-control" name="name" required />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="name_es">Nombre (espa&ntilde;ol)</label>
                            <input type="text" class="form-control" name="name_es" required />
                        </div>
                    </div>
                </div>

                  @can('update', $page)
                  <div class="col-md-12 text-right">
                      <button type="submit" class="btn btn-info">Crear</button>
                  </div>
                  @endcan
                {!! Form::close() !!}



                  <div class="col-md-12 gallery-items">
                      {{--<div class="img-choose" style="background-image: url('/mediafiles/pages/2019/01/74/la-brise.jpg')">--}}
                          {{--<img src="{{ asset('cms/images/delete.png') }}" alt="">--}}
                      {{--</div>--}}
                  </div>

                  <div class="col-md-12 gallery-page-media">
                      <div class="row gallery-grid selectable-media" id="extra-mediafiles">
                          @foreach($page->mediafiles as $key => $image)
                              <div class="col-md-3">
                                  <div class="media-page" style="background-image: url({{ $image->path }})">
                                      <div class="media-actions add-to-gallery" id="media-action-{{ $image->id }}" data-src="{{ $image->path }}" data-media="{{ $image->id }}">
                                          <img src="{{ asset('cms/images/add.png') }}" alt="" />
                                          <p>{{ $image->translations->implode('locale', ', ') }}</p>
                                      </div>
                                      <div class="selected-overlay"></div>
                                  </div>
                              </div>
                          @endforeach
                      </div>
                  </div>
                  <div class="col-md-12 text-right">
                      <a id="load-extra-mediafiles" class="btn btn-info" data-add-icon-src="{{ asset('cms/images/add.png') }}" data-load-url="{{ route('galleries.from-page.extra-mediafiles', $page->id) }}" data-actions-class="add-to-gallery" href="javascript:void(0);">Cargar m&aacute;s im&aacute;genes</a>
                  </div>
            </div>
        </div>
    </div>

@endsection
