@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page) }}
    </section>
@endsection

@section('content')
    <div class="box box-default">
        <div class="box-header">
            <h3 class="box-title">Postales</h3>
            <div class="text-right">
                @can('update', $page)
                <a href="{{ route('pages.show', [$page->id, app()->getLocale()]) }}" class="btn btn-primary">
                    Finalizar
                </a>
                @endcan
            </div>
            <div class="dd cards-nestable" data-url="{{ route('cards.update.priority', $page) }}">
                <ol class="dd-list">
                    @foreach($cards as $i => $card)
                    <li class="dd-item" data-id={{ $card->id }}>
                            <div class="dd-handle">
                            {{ ($card->title) ? $card->title : $card->slug }}
                        </div>
                    </li>
                    @endforeach
                </ol>
            </div>
        </div>
    </div>

@endsection
