@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $card->page, $card, $lang) }}
    </section>
@endsection

@section('content')


@include('MGCms2019::admin.partials.formErrors')
{!! Form::model($card, ['route' => ['cards.update', $card->id], 'method' => 'put']) !!}
<input type="hidden" name="id" value="{{ $card->id }}">
<input type="hidden" name="locale" value="{{ $lang }}">
<input type="hidden" name="image" id="image-card-component" value="{{ $card->image }}">
<div class="row">
    <div class="col-md-6">
        @can('update', $card->page)
        <a href="{{ route('cards.edit', [$card->id, ($lang == 'en') ? 'es' : 'en']) }}">
            @if($lang == 'es')
                <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="" class="">
                @else
                <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="" class="">
            @endif
        </a>
        @endcan
    </div>
    @can('update', $card->page)
    <div class="col-md-6 text-right">
        <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Postal guardada">Guardar</a>
        <button type="submit" class="btn btn-info">Guardar y cerrar</button>
    </div>
    @endcan
    <div class="col-md-6">
        <div class="form-group">
            <label for="Titulo">T&iacute;tulo</label>
            <input type="text" class="form-control" name="title" value="{{ $card->title }}" placeholder="Title">
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="Titulo">Subt&iacute;tulo</label>
            <input type="text" class="form-control" name="title_two" value="{{ $card->title_two }}" placeholder="Sub title">
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="Titulo">V&iacute;nculo</label>
            <input type="text" class="form-control" name="link" value="{{ $card->link }}">
        </div>
    </div>
    <div class="col-md-12">
        <div class="form-group">
            <label for="coontet">Contenido</label>
            <textarea class="form-control wysiwyg" name="body">{{ $card->body }}</textarea>
        </div>
    </div>

    <div class="col-md-12 gallery-page-media">
        <div class="row gallery-grid" id="extra-mediafiles">
            @foreach($mediafiles as $key => $image)
                <div class="col-md-3">
                    <div class="media-page" style="background-image: url({{ $image->path }})">
                        <div class="media-actions card-image-component {{ ($image->path === $card->image) ? 'disabled-image' : '' }}"
                             data-src="{{ $image->path }}">
                            <img src="{{ asset('cms/images/add.png') }}" alt="">
                            <p>{{ $image->translations->implode('locale', ', ') }}</p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    <div class="col-md-12 text-right">
        <a id="load-extra-mediafiles" class="btn btn-info" data-add-icon-src="{{ asset('cms/images/add.png') }}" data-load-url="{{ route('cards.extra-mediafiles', [$card->id, $lang]) }}" data-actions-class="card-image-component" href="javascript:void(0);">Cargar m&aacute;s im&aacute;genes</a>
    </div>
</div>
{!! Form::close() !!}
@endsection
