@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, $lang) }}
    </section>
@endsection

@section('content')

@include('MGCms2019::admin.partials.formErrors')
    <div class="box box-default card-create-panel">
        <div class="box-card with-border">
            <h3 class="box-title">Crear Postal</h3>
        </div>
        <div class="box-body">
            {!! Form::open(['route' => ['cards.store'], 'method' => 'post']) !!}
            <input type="hidden" name="page_id" value="{{$page->id}}">
            <input type="hidden" name="priority" value="{{$priority}}">
            <input type="hidden" name="locale" value="{{ $lang }}">
            <input type="hidden" name="image" id="image-card-component">
            <div class="row">
                @can('update', $page)
                <div class="col-md-12 text-right">
                    <button type="submit" class="btn btn-info">Crear</button>
                </div>
                @endcan
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="Titulo">T&iacute;tulo</label>
                        <input type="text" class="form-control" name="title" placeholder="Title">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="Titulo">Subt&iacute;tulo</label>
                        <input type="text" class="form-control" name="title_two" placeholder="Sub title">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="Titulo">V&iacute;nculo</label>
                        <input type="text" class="form-control" name="link">
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group">
                        <label for="coontet">Contenido</label>
                        <textarea class="form-control wysiwyg" name="body"></textarea>
                    </div>
                </div>

                <div class="col-md-12 gallery-page-media">
                    <div class="container">
                         <div class="row gallery-grid" id="extra-mediafiles">
                            <div class="col-md-12"><h5>Im&aacute;genes</h5></div>
                            @foreach($page->mediafiles as $key => $image)
                                <div class="col-md-3 media-page" style="background-image: url({{ $image->path }})">
                                    <div class="media-actions card-image-component" data-src="{{ $image->path }}">
                                        <img src="{{ asset('cms/images/add.png') }}" alt="">
                                        <p>{{ $image->translations->implode('locale', ', ') }}</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="col-md-12 text-right">
                    <a id="load-extra-mediafiles" class="btn btn-info" data-add-icon-src="{{ asset('cms/images/add.png') }}" data-load-url="{{ route('cards.from-page.extra-mediafiles', [$page->id, $lang]) }}" data-actions-class="card-image-component" href="javascript:void(0);">Cargar m&aacute;s im&aacute;genes</a>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>

@endsection
