@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, $lang) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default add-room-form">
                <div class="box-header with-border">
                    <h3>Crear Habitaci&oacute;n</h3>
                </div>

                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::open(['route' => 'rooms.store', 'methods' => 'post', 'files' => true]) !!}
                    {!! Form::hidden('page_id', $page->id) !!}
                    {!! Form::hidden('locale', $lang) !!}
                    <div class="row">
                            {!! Form::hidden('name', $page->name, ['class' => 'form-control', 'readonly']) !!}
                        <div class="form-group col-md-6">
                            <label for="">C&oacute;digos de API</label>
                            <div class="room-api-codes">
                                <div class="mb-3">
                                    <button class="btn btn-outline-secondary btn-block room-api-codes-add" type="button">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                <div class="room-api-codes-definitions"></div>
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Categor&iacute;a:</label>
                            {!! Form::select('category_id', $categories->pluck('category', 'id'), '', ['class' => 'form-control']) !!}
                        </div>
                        <div class="form-group col-md-4">
                            <label>Capacidad</label>
                            {!! Form::text('capacity_room', old('capacity_room'), ['class' => 'form-control', 'required']) !!}
                        </div>
                        <div class="form-group col-md-4">
                            <label>Adultos</label>
                            {!! Form::text('adults_room', old('adults_room'), ['class' => 'form-control', 'required']) !!}
                        </div>
                        <div class="form-group col-md-4">
                            <label>Ni&ntilde;os</label>
                            {!! Form::text('childrens_room', old('childrens_room'), ['class' => 'form-control', 'required']) !!}
                        </div>
                        <div class="col-md-12">
                            <div class="capacities row">
                                <div class="col-12">
                                    <span class="badge badge-info">Ocupaci&oacute;n permitida</span>
                                    <div class="form-group col-md-12 text-right">
                                        <button type="button" class="btn btn-info" id="add-capacity">+ Agregar capacidad</button>
                                    </div>
                                    {{--
                                        2020-01-25: Vestigial, como prueba de concepto.
                                        Esta plantilla es ya generada dinámicamente, bajo demanda
                                        por una función en Javascript. 

                                        2020-01-25: Nope! Son obligatorias. NO es vestigial.
                                    --}}
                                    <div class="row align-items-center">
                                        <div class="form-group col-md-2">
                                            <label>Capacidad</label>
                                            {!! Form::text('capacity[]', null, ['class' => 'form-control', 'required']) !!}
                                        </div>
                                        <div class="col-md-5">
                                            <br />
                                            <div class="input-group">
                                              <div class="">
                                                <span class="input-group-text">S&iacute;: </span>
                                              </div>
                                                {!! Form::text('adults[]', null, ['class' => 'form-control', 'required', 'placeholder=Adultos ']) !!}
                                                {!! Form::text('childrens[]', null, ['class' => 'form-control', 'required', 'placeholder=Niños ']) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <br />
                                            <div class="input-group">
                                              <div class="">
                                                <span class="input-group-text">No:</span>
                                              </div>
                                                 {!! Form::text('adults_n[]', null, ['class' => 'form-control', 'required', 'placeholder=Adultos ']) !!}
                                                 {!! Form::text('childrens_n[]', null, ['class' => 'form-control', 'required', 'placeholder=Niños ']) !!}
                                            </div>
                                        </div>
                                    </div>
                               </div>
                            </div>
                        </div>
                        <div class="form-group col-md-4 ">
                            <label for="">Camas</label>
                            {!! Form::text('beds', old('beds'), ['class' => 'form-control', 'required']) !!}
                        </div>
                        <div class="form-group col-md-4 ">
                            <label for="">Ba&ntilde;os</label>
                            {!! Form::text('bathrooms', old('bathrooms'), ['class' => 'form-control', 'required']) !!}
                        </div>
                        <div class="form-group col-md-4">
                            <label for="">&Aacute;rea de piso</label>
                            {!! Form::text('floor_area', old('floor_area'), ['class' => 'form-control', 'required']) !!}
                        </div>
                        <div class="col-md-12">
                            <label>Mapa 3D</label>
                        </div>
                        <div class="form-group col-md-12">
                            {!! Form::textarea('mapa', old('map_3d'), ['class' => 'form-control', 'rows' => 3]) !!}
                        </div>
                        <div class="col-md-12">
                            <label>Amenidades</label>
                        </div>

                        <div class="form-group col-md-12">
                            <ul class="amenities-list">
                                @foreach($amenities as $amenity)
                                <li>
                                    <label for="">{!! Form::checkbox('amenity[]', $amenity->id) !!} {{ $amenity->name }}</label>
                                </li>
                                @endforeach
                            </ul>
                        </div>


                        <div class="form-group col-md-4">
                            <div class="custom-file">
                               {!! Form::file('floor_plan', ['class' => 'custom-file-input']) !!}
                              <label class="custom-file-label" for="customFile">Floor Plan</label>
                            </div>
                        </div>

                    </div>

                    @can('update', $page)
                    <div class="text-right">
                        <button type="submit" class="btn btn-info">Crear</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>

            </div>
        </div>
    </div>
@endsection
