@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Categor&iacute;as</h3>
                    <div class="col-md-12 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Accommodations\Category::class)
                        <a href="{{ route('categories.create') }}" class="btn btn-primary">Crear Categor&iacute;a</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Nombre</th>
                            <th>Nombre (Espa&tilde;ol)</th>
                            <th>Fecha de creaci&oacute;n</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>

                        @foreach($categories as $category)
                            <tr>
                                <td>{{ $category->id }}</td>
                                <td>{{ $category->category }}</td>
                                <td>{{ $category->category_es }}</td>
                                <td>{{ $category->created_at }}</td>
                                <td>
                                    @can('update', $category)
                                    <a href="{{ route('categories.edit', $category) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="far fa-edit"></i></a>
                                    @endcan
                                    @can('delete', $category)
                                    <a href="{{ route('categories.destroy', $category) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="far fa-trash-alt"></i></a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                        <tfoot>
                          <tr>
                              <th>#ID</th>
                              <th>Nombre</th>
                              <th>Nombre (Espa&tilde;ol)</th>
                              <th>Fecha de creaci&oacute;n</th>
                              <th>Acciones</th>
                          </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>
@endsection
