@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3>Crear Categor&iacute;a</h3>
                    <div class="col-md-12 text-right">
                        @can('viewAny', AvengersMG\MGCms2019\App\Cms\Accommodations\Category::class)
                        <a href="{{ route('categories.index') }}" class="btn btn-primary">Regresar a Categor&acute;as</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::open(['route' => 'categories.store', 'methods' => 'post']) !!}
                    <div class="form-group col-md-6">
                        <label>Nombre:</label>
                        {!! Form::text('category', old('category'), ['class' => 'form-control', 'required']) !!}
                    </div>
                    <div class="form-group col-md-6">
                        <label>Nombre (Espa&ntilde;ol):</label>
                        {!! Form::text('category_es', old('category_es'), ['class' => 'form-control', 'required']) !!}
                    </div>
                    @can('create', AvengersMG\MGCms2019\App\Cms\Accommodations\Category::class)
                    <div class="box-footer text-right">
                        <button type="submit" class="btn btn-info">Crear</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>

            </div>
        </div>
    </div>
@endsection
