@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <div class="col-md-12 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity::class)
                        <a href="{{ route('amenities.create') }}" class="btn btn-primary"><i class="fas fa-plus"></i> Crear Amenidad</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body" id="usser-tables">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable username-table">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Nombre</th>
                            <th>Nombre (Espa&ntilde;ol)</th>
                            <th>&Iacute;cono</th>
                            <th>Imagen</th>
                            <th>Fecha de creaci&oacute;n</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($amenities as $amenity)
                            <tr>
                                <td>{{ $amenity->id }}</td>
                                <td>{{ $amenity->name }}</td>
                                <td>{{ $amenity->name_es }}</td>
                                <td>{{ $amenity->icon }}</td>
                                <td class="text-center">
                                    <img src="{{ asset($amenity->image) }}" alt="" />
                                </td>
                                <td>{{ $amenity->created_at }}</td>
                                <td>
                                    @can('update', $amenity)
                                    <a href="{{ route('amenities.edit', $amenity) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                    @endcan
                                    @can('delete', $amenity)
                                    <a href="{{ route('amenities.destroy', $amenity) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="far fa-trash-alt"></i></a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                        <tfoot>
                          <tr>
                              <th>#ID</th>
                              <th>Nombre</th>
                              <th>Nombre (Espa&ntilde;ol)</th>
                              <th>&Iacute;cono</th>
                              <th>Imagen</th>
                              <th>Fecha de creaci&oacute;n</th>
                              <th>Acciones</th>
                          </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>

@endsection
