@extends('MGCms2019::admin.layouts.admin')
@section('breadcrumbs')
<section class="content-header">
    <h1>Gorilla CMS </h1>
    {{ Breadcrumbs::render(Route::currentRouteName(), $amenity) }}
</section>
@endsection

@section('content')

<div class="row">
    <div class="col-md-12">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3>Editar Amenidad</h3>
                <div class="col-md-12 text-right">
                    @can('viewAny', AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity::class)
                    <a href="{{ route('amenities.index') }}" class="btn btn-primary">Regresar a Amenidades</a>
                    @endcan
                </div>
            </div>

            <div class="box-body">
    @include('MGCms2019::admin.partials.formErrors')
    {!! Form::model($amenity, ['route' => ['amenities.update', $amenity], 'method' => 'put', 'files' => true]) !!}
    @include('MGCms2019::admin.components.accommodations.amenities.partials.form')
                @if($amenity->image)
                <img src="{{ asset($amenity->image) }}" alt="" class="">
                @endif
                @can('update', $amenity)
                <div class="box-footer text-right">
                    <button type="submit" class="btn btn-info">Guardar</button>
                </div>
                @endcan
                {!! Form::close() !!}
            </div>

        </div>
    </div>
</div>
@endsection
