@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')

<div class="col-md-12">
    @include('MGCms2019::admin.partials.formErrors')
    {!! Form::open(['route' => 'amenities.store', 'methods' => 'post', 'files' => true]) !!}
    <div class="box-header with-border">
        <h3>Crear Amenidad</h3>
        <div class="col-md-12 text-right">
            @can('viewAny', AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity::class)
            <a href="{{ route('amenities.index') }}" class="btn btn-primary">Regresar a Amenidades</a>
            @endcan
        </div>
    </div>
        @include('MGCms2019::admin.components.accommodations.amenities.partials.form')
        @can('create', AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity::class)
        <div class="box-footer text-right">
            <button type="submit" class="btn btn-info">Crear</button>
        </div>
        @endcan
    {!! Form::close() !!}
</div>


@endsection
