@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection


@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <div class="col-md-12 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Banners\Banner::class)
                        <a href="{{ route('banners.create') }}" class="btn btn-primary">Create Banner</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body" id="usser-tables">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable username-table">
                        <thead>
                        <tr>
                            <th>Nombre:</th>
                            <th>Posición</th>
                            <th>tipo</th>
                            <th>caption</th>
                            <th>img</th>
                            <th>Prioridad</th>
                            <th>Fecha de inicio</th>
                            <th>Fecha final</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($banners as $banner)
                            <tr>
                                <td>{{ $banner->translateOrDefault('es')->name }}</td>
                                <td>{{ $banner->position }}</td>
                                <td>{{ $banner->type }}</td>
                                <td>{{ $banner->translateOrDefault('es')->caption }}</td>
                                <td>
                                    <img src="{{ $banner->translateOrDefault('es')->img }}" alt="" style="width: 80px">
                                </td>
                                <td>{{ $banner->priority }}</td>
                                <td>{{ $banner->start_date }}</td>
                                <td>{{ $banner->end_date }}</td>
                                <td class="text-center">
{{--                                    <a href="{{ route('users.show', $banner) }}" class="btn btn-info btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Ver actividad"><i class="fa fa-eye"></i></a>--}}
                                    @can('update', $banner)
                                    @foreach($banner->getTranslationsArray() as $lang => $item)
                                        <a href="{{ route('banners.edit', [$banner, $lang]) }}" class="btn btn-success btn-small tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar">
                                            @if($lang == 'en')
                                                <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="">
                                                @else
                                                    <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="">
                                            @endif
                                        </a>
                                    @endforeach
                                    @endcan
                                    @can('delete', $banner)
                                    <a href="{{ route('banners.destroy', $banner) }}" class="btn btn-sm btn-danger tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="far fa-trash-alt"></i></a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>name</th>
                            <th>position</th>
                            <th>type</th>
                            <th>caption</th>
                            <th>img</th>
                            <th>Priority</th>
                            <th>start_date</th>
                            <th>end_date</th>
                            <th>Actions</th>
                        </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>

@endsection
