@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $banner, app()->getLocale()) }}
    </section>
@endsection

@section('content')

    <div class="col-md-12">
        <div class="box-header with-border">
            <h3>Edit Banner {{ $banner->name }}</h3>
        </div>
        <div class="nav-tabs-custom">
            @if(app()->getLocale() == 'en')
                <a href="{{ route('banners.edit', [$banner->id, 'es']) }}">
                    <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="">
                </a>
            @else
                <a href="{{ route('banners.edit', [$banner->id, 'en']) }}">
                    <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="">
                </a>
            @endif
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a href="#site-content" data-toggle="tab" aria-expanded="true" class="nav-link active">Informaci&oacute;n de la p&aacute;gina</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="site-content">
                    {!! Form::model($banner, ['route' => ['banners.update', $banner], 'method' => 'PUT ', 'files' => true]) !!}
                    {!! Form::hidden('_method', 'PUT') !!}
                    {!! Form::hidden('locale', app()->getLocale()) !!}
                    <div class="box-body">
                        @include('MGCms2019::admin.partials.formErrors')
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label>Name</label>
                                {!! Form::text('name', old('name'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Start date</label>
                                {!! Form::text('start_date', old('start_date'), ['class'  => 'form-control date-single']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>End date</label>
                                {!! Form::text('end_date', old('end_date'), ['class'  => 'form-control date-single']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Position</label>
                                {!! Form::select('position', ['top' => 'Top', 'left' => 'left', 'bottom' => 'bottom', 'right' => 'right'], $banner->position,['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Type</label>
                                {!! Form::select('type', ['img' => 'img', 'text' => 'text'], $banner->type,['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Priority</label>
                                {!! Form::select('priority', ['1' => 'Normal', '3' => 'High'], $banner->priority,['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>URL (on site) </label>
                                {!! Form::select('page_id', $pages, ($banner->page) ? $banner->page->id : '', ['class'  => 'form-control select2', 'id' => 'select-url']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>URL (custom)</label>
                                {!! Form::text('url_custom', old('url_custom'), ['class'  => 'form-control static-url']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>duration</label>
                                {!! Form::number('duration', old('duration'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-12">
                                {!! Form::checkbox('countdown', '1', ['class' => 'form--check-input', 'checked' =>($banner->countdown) ? true : '' ]) !!}
                                <label class="form-check-label" for="navigation">
                                    Countdown
                                </label>
                            </div>
                            <div class="form-group col-md-12">
                                <img src="{{ $banner->img }}" alt="" width="150px">
                            </div>
                            <div class="form-group col-md-12">
                                <label>Imagen</label>
                                {!! Form::file('img', ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-6">
                                <label>Caption</label>
                                {!! Form::text('caption', old('caption'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-12">
                                <label>Body</label>
                                {!! Form::textarea('body', old('body'), ['class'  => 'wysiwyg']) !!}
                            </div>
                            @can('update', $banner)
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-info">Update</button>
                            </div>
                            @endcan
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>

@endsection
