@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')

    <div class="col-md-12">
        <div class="box-header with-border">
            <h3>Nuevo Banner</h3>
        </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a href="#site-content" data-toggle="tab" aria-expanded="true" class="nav-link active">Informaci&oacute;n de la p&aacute;gina</a>
                </li>
            </ul>
            <div class="tab-content" id="site-content">
                <div class="tab-pane active" >
                    {!! Form::open(['route' => ['banners.store'], 'method' => 'post', 'files' => true]) !!}
                    <div class="box-body">
                        @include('MGCms2019::admin.partials.formErrors')
                        <div class="row">
                            <div class="form-group col-md-2">
                                <label>Lang</label>
                                {!! Form::select('locale', ['en' => 'en', 'es' =>'es'], 'en',
                                ['class'  => 'form-control lang-banner', '
                                 data-route' => route('urls.pages', 'es')]) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Name</label>
                                {!! Form::text('name', old('name'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-3">
                                <label>Start date</label>
                                {!! Form::text('start_date', old('start_date'), ['class'  => 'form-control date-single']) !!}
                            </div>
                            <div class="form-group col-md-3">
                                <label>End date</label>
                                {!! Form::text('end_date', old('end_date'), ['class'  => 'form-control date-single']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Position</label>
                                {!! Form::select('position', ['top' => 'Top', 'left' => 'left', 'bottom' => 'bottom', 'right' => 'right'], 'bottom',['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Type</label>
                                {!! Form::select('type', ['img' => 'img', 'text' => 'text'], 'bottom',['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Priority</label>
                                {!! Form::select('priority', ['1' => 'normal', '3' => 'high'], 'normal',['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>URL (on site) </label>
                                {!! Form::select('page_id', $pages, old('page_id'), ['class'  => 'form-control select2', 'id' => 'select-url']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>URL (custom)</label>
                                {!! Form::text('url_custom', old('url_custom'), ['class'  => 'form-control static-url']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>duration</label>
                                {!! Form::number('duration', old('duration'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-8">
                                <div class="custom-file">
                                    {!! Form::file('img', ['class'  => 'custom-file-input']) !!}
                                  <label class="custom-file-label" for="customFile">Imagen</label>
                                </div>
                            </div>
                            <div class="form-group col-md-2">
                                <div class="custom-control custom-switch">
                                    {!! Form::checkbox('countdown', 0, false, ['id' => 'checkbox-countdown', 'class' => 'custom-control-input']) !!}
                                  <label class="custom-control-label" for="checkbox-countdown">Cuenta regresiva</label>
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                <label>Caption</label>
                                {!! Form::text('caption', old('caption'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-12">
                                <label>Body</label>
                                {!! Form::textarea('body', old('body'), ['class'  => 'wysiwyg']) !!}
                            </div>
                           
                            @can('create', AvengersMG\MGCms2019\App\Cms\Banners\Banner::class)
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-info">Crear</button>
                            </div>
                            @endcan
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>

@endsection
