@extends('MGCms2019::admin.layouts.admin')

@section('content')

<div class="col-md-12 margin-bottom">
    @can('updateAll', AvengersMG\MGCms2019\App\Cms\Availabilities\Availability::class)
    {!! Form::open(['route' => 'import.store', 'method' => 'post', 'class' => 'dropzone', 'id' => 'file-excel', 'files' => true]) !!}
        <div class="fallback">
            <input name="file" type="file" multiple />
        </div>
    {!! Form::close() !!}
    @endcan
</div>

<div class="col-md-12 text-center">
    <h4>&Uacute;ltima actualizaci&oacute;n:</h4>
    <div id="last-availability-update-info">
    @if (!is_null($latestChange))
      Hecha en {{ $latestChange->created_at->toDateString() }} por el usuario @isset($latestChange->user) {{ $latestChange->user->name }} @else Desconocido @endisset
    @else
      <em>Nunca</em>
    @endif
    </div>
</div>

<div class="container" id="zone-content">
	<table class="table table-striped">
	  <thead>
	    <tr>
	      <th scope="col">#</th>
	      <th scope="col">API code ID</th>
	      <th scope="col">Status</th>
	      <th scope="col">Date</th>
	    </tr>
	  </thead>
	  <tbody class="zone-item">
	  	@foreach($fechas as $fecha)
		    <tr>
		      <th scope="row">{{$fecha->id}}</th>
		      <td>{{$fecha->room_api_code_id}}</td>
		      <td>{{$fecha->status}}</td>
		      <td>{{$fecha->date}}</td>
		    </tr>
	    @endforeach
	  </tbody>
	</table>
	{{$paginate}}
</div>

@endsection
