/*
  2019-06-19: Vestigial.

  El componente "Media" fue purgado, junto con el controlador Components\MediaController y sus vistas
 */
$('.radiomodel').click((ob) => {
    //fill links
    $.ajax({
        type: 'GET',
        url: ob.target.dataset.permalinkUrl,
        contentType: 'json',
        headers: {
            'X-CSRF-Token': $('meta[name="_token"]').attr('content')
        },
        success: function (res) {
            permalinks =  $.map(res, function (vv) { return { value: vv}; });
            // Initialize autocomplete with local lookup:
            $('#autocomplete').devbridgeAutocomplete({
                lookup: permalinks,
                minChars: 1,
                onSelect: function (suggestion) {
                    $('#selection').html('Link selected: ' + suggestion.value );
                },
                showNoSuggestionNotice: true,
                noSuggestionNotice: 'Ingresa tu propio link',
            });
        },
        error: function (xhr, ajaxOptions, thrownError) {
            console.log(xhr.status);
            console.log(thrownError);
        }
    });



    $('#imgsadmin').css('visibility','visible')
    $.ajax({
        type: 'GET',
        url: ob.target.dataset.url,
        contentType: 'json',
        headers: {
            'X-CSRF-Token': $('meta[name="_token"]').attr('content')
        },
        success: function (response) {
            localStorage.setItem('model', ob.target.dataset.modelo)
            $('#selectComponent').empty();
            response.forEach(ee => {
                $('#selectComponent').append($('<option>', {
                    value: ee.id,
                    text: ee.name
                }));
            });
        },
        error: function (xhr, ajaxOptions, thrownError) {
            console.log(xhr.status);
            console.log(thrownError);
        }
    });
});

$('#formimages').submit((e) => {
    e.preventDefault();
    var slt = document.getElementById('selectComponent');
    $.ajax({
        type: 'GET',
        url: localStorage.getItem('model') + "/" + slt.options[slt.options.selectedIndex].value,
        contentType: 'json',
        headers: {
            'X-CSRF-Token': $('meta[name="_token"]').attr('content')
        },
        success: function (res) {
            $('#imageContent').empty();
            if (res.length == 0) alert('Este registro no tiene imagenes')
            res.forEach(rr =>{
                $('#imageContent')
                .append($('<div>',{
                    class:"col-md-4"
                })
                .append($('<img>', {
                    width:"300px",
                    height:"300px",
                    src: rr.path,
                }))
                .append($('<input>',{
                    value:rr.path,
                    width:"300px"
                }).on('click',(e)=>{
                    e.target.select();
                    document.execCommand("copy");
                }))
                .append($('<input>',{
                    id:'title'+rr.id,
                    type:'text',
                    value:rr.title
                }))
                .append($('<input>',{
                    id:'description'+rr.id,
                    type:'text',
                    value:rr.description
                }))
                .append($('<input>',{
                    id:'priority'+rr.id,
                    type:'number',
                    min:0,
                    value:rr.priority
                }))
                .append($('<input>',{
                    id:'link'+rr.id,
                    type:'text',
                    value:rr.link
                }))
                .append($('<button>',{
                    type:'button',
                    class:'btn btn-primary',
                    text:'Actualizar Datos',
                    width:"300px"
                }).on('click',()=>{
                    if(confirm("deseas Actualizar los datos de la imagen?"))
                         $.ajax({
                            type: 'PUT',
                            url: '/admin/files/update/'+rr.id,
                            data: JSON.stringify({
                                id:rr.id,
                                title:$('#title'+rr.id).val(),
                                description:$('#description'+rr.id).val(),
                                link:$('#link'+rr.id).val(),
                                priority:$('#priority'+rr.id).val()
                            }),
                            contentType: 'json',
                            headers: {
                                'X-CSRF-Token': $('meta[name="_token"]').attr('content')
                            },
                             success: function (response) {
                                alert("se actualizo correctamente "+response.title);
                                $('#formimages').submit();
                             },
                             error: function (xhr, ajaxOptions, thrownError) {
                                 console.log(xhr.status);
                                 alert(thrownError);
                             }
                         });

                    })
                )
                .append($('<button>',{
                    type:'button',
                    class:'btn btn-danger',
                    text:'Borrar imagen',
                    width:"300px"
                }).on('click',()=>{
                   if(confirm("deseas borrar la imagen?"))
                        $.ajax({
                            type: 'DELETE',
                            url: '/admin/files/delete/image/x',
                            data: JSON.stringify(rr.id),
                            contentType: 'json',
                            headers: {
                                'X-CSRF-Token': $('meta[name="_token"]').attr('content')
                            },
                            success: function (idDeleted) {
                                $('#formimages').submit();
                            },
                            error: function (xhr, ajaxOptions, thrownError) {
                                console.log(xhr.status);
                                console.log(thrownError);
                            }
                        });

                    })
                ));
            });
        },
        error: function (xhr, ajaxOptions, thrownError) {
            console.log(xhr.status);
            console.log(thrownError);
        }
    });
});



$('#formimagesupload').submit((e) => {
    e.preventDefault();
    var input = document.getElementById('inputFile');
    var slt = document.getElementById('selectComponent');
    //console.log( new FormData(input.files[0]));

    var formData = new FormData();
    formData.append('file', input.files[0]);
    formData.append('id', slt.options[slt.options.selectedIndex].value)
    formData.append('title',e.target['title'].value);
    formData.append('link',e.target['link'].value);
    formData.append('priority',e.target['priority'].value);
    formData.append('description',e.target['description'].value);

    $.ajax({
        type: 'POST',
        url: localStorage.getItem('model') + "/" + slt.options[slt.options.selectedIndex].value,
        processData: false,
        contentType: false,
        data:formData,
        headers: {
            'X-CSRF-Token': $('meta[name="_token"]').attr('content')
        },
        success: function (res) {
            console.log(res);
            $('#formimages').submit();
            e.target.reset();
        },
        error: function (xhr, thrownError) {
            console.log(xhr.status);
            console.log(thrownError);
        }
    });
});
