(function($){
    $('#file-detail-modal').on('show.bs.modal', function (e) {
        var container = $(e.relatedTarget);
        var route = container.data('route');
        var type_id = container.data('type');
        var id = container.data('id');
        var update = container.data('update');
        var destroy = container.data('delete');
        var lang = container.data('lang');
        var languageDeleteRoutes = container.data('lang-delete-routes');
        var modal = $(this);
        var language_selector = modal.find('select[name=locale]');

        /* Eliminar eventos anteriores */
        language_selector.off('change');

        /* Añadir nuevo evento */
        language_selector.change(function () {
            MGCms2019RefreshModal(modal, route, $(this).val(), update, destroy, type_id, id, languageDeleteRoutes);
        });

        /*
            Cambiar el lenguaje de acuerdo con la disponibilidad
            y ejecutar cambio de modal
        */
        language_selector.val(lang).change();
    });


    $('#update-sites-media,#form-media-files').on('submit', function (e) {
        e.preventDefault();
        $.ajax({
            type: $(this).attr('method'),
            url: $(this).attr('action'),
            data: $(this).serialize(),
            success: function (file) {
                var mediaObject = $('.media-item.media-item-' + file.id),
                    mediaHasFileType = mediaObject.find('.file-type').length > 0;
                fileTypeExist = file.hasOwnProperty('type') && file.type !== null;

                /* Actualizar imagen */
                mediaObject.find('.file-image').css('background-image', 'url(' + file.path + ')');
                mediaObject.data('path', file.path);

                /* Actualizar lenguajes */
                mediaObject.find('.file-image-languages').text(
                    file.translations.map(function (translation) {
                        return translation.locale;
                    }).join(', ')
                );

                /* Actualizar tipo de archivo */
                if (fileTypeExist) {
                    /* Elemento de tipo de medio, para uso futuro */
                    let mediaType = (mediaHasFileType)
                        ? mediaObject.find('.file-type')
                        : $('<p />').appendTo(mediaObject);

                    /* Resetear clases originales */
                    mediaType.attr("class", "file-type type-" + file.type.type);

                    /* Escribir texto nuevo */
                    mediaType.text(
                        file.type.type
                    );

                    /* Escribir tipo nuevo en datos de HTML */
                    mediaObject.data('type', file.type_id);
                } else if (mediaHasFileType) {
                    /* Remover elemento, porque no tiene */
                    mediaObject.find('.file-type').remove();

                    /* Escribir tipo nuevo en datos de HTML */
                    mediaObject.data('type', '');
                }

                /* Cerrar modal */
                $('#file-detail-modal').modal('hide');
                swal('Modificado correctamente');
            },
            error: function (xhr, thrownError) {
                console.log(xhr.status);
                console.log(thrownError);
            }
        });
    });

    /**
     * Función pública para alimentar la vista de objeto Mediafile en la
     * descripción de la página
     *
     * @param       {jQuery}      modal                 Objeto de modal
     *                                                  a modificar
     * @param       {string}      route                 URL para información
     *                                                  de modelo
     * @param       {string}      lang                  Identificador de
     *                                                  localización
     * @param       {string}      update                URL para actualización
     *                                                  de modelo
     * @param       {string}      delete                URL para eliminación
     *                                                  de modelo
     * @param       {int}         type_id               Identificador de
     *                                                  tipo interno
     * @param       {int|null}    id                    Identificador
     *                                                  de modelo
     * @param       {Object}      languageDeleteRoutes  Objeto con las URl
     *                                                  tentativas para
     *                                                  eliminar traducciones
     */
    function MGCms2019RefreshModal(modal, route, lang, update, destroy, type_id, id, languageDeleteRoutes) {
        var isTranslation = false,
            translationDeleteButton = modal.find('.mediafile-translation-delete'),
            translationInexistentMessage = modal.find('.mediafile-translation-inexistent'),
            deleteButton = modal.find('.modal-delete-mediafile'),
            idInput = modal.find('input[name=id]');

        modal.find('form').attr('action', update);

        /* Remover eventos anteriores */
        deleteButton.off('delete-model-success delete-model-error');

        /* Cambiar la dirección para destruir el modelo */
        deleteButton.attr('href', destroy);

        /* Función de retrollamada para ejecutar el borrado del objeto en el DOM */
        deleteButton.on('delete-model-success', function (e, data) {
            /* Si el estado HTTP es 201, data es NULL. Eliminar columna contenedora */
            $('.media-item.media-item-' + id).parent().fadeOut(400, function () {
                $(this).remove();
            });

            /* Cerrar modal */
            modal.modal('hide');
            toastr.success('El medio fue eliminado exitosamente', 'SUCCESS!');
        });

        /* Función de retrollamada para mostrar mensaje de error */
        deleteButton.on('delete-model-error', function (e, response) {
            toastr.error('El medio no fue eliminado', 'ERROR!');
        });

        /* Establecer ID, si existe */
        if (idInput.length > 0) {
            idInput.val(id);
        }

        $.get((route + "/" + lang), function (response) {
            modal.find('#selected_image').attr('src', response.path);
            modal.find('input[name=path]').val(response.path);
            modal.find('input[name=name]').val(response.name);
            modal.find('input[name=title]').val(response.title);
            modal.find('input[name=alt]').val(response.alt);
            modal.find('input[name=link]').val(response.link);
            modal.find('input[name=file_size]').val(response.file_size);
            modal.find('input[name=title]').val(response.title);
            modal.find('textarea[name=description]').val(response.description);
            modal.find('select[name=type_id]').val(type_id);

            /* Revisar si existe la traducción */
            isTranslation = response.translations.find(function (translation) {
                return translation.locale == lang;
            }) !== undefined;

            if (translationDeleteButton.length > 0) {
                /*
                    Variables sólo para este control de flujo, para mantener
                    código DRY
                */
                let hideTranslationDeleteButton = function () {
                    /* Remover dirección y esconder */
                    translationDeleteButton.attr('href', '#');
                    translationDeleteButton.addClass('d-none');

                    /* Mostrar el mensaje de inexistencia */
                    translationInexistentMessage.removeClass('d-none');
                },
                    showTranslationDeleteButton = function (newHref) {
                        /* Esconder el mensaje de inexistencia */
                        translationInexistentMessage.addClass('d-none');

                        /* Añadir dirección y mostrar */
                        translationDeleteButton.attr('href', newHref);
                        translationDeleteButton.removeClass('d-none');
                    };

                /* Remover eventos anteriores */
                translationDeleteButton.off('delete-model-success delete-model-error');

                if (isTranslation) {
                    /* Función de retrollamada para mostrar botón de borrado */
                    translationDeleteButton.on('delete-model-success', function (e, data) {
                        /* Actualizar lenguajes */
                        $('.media-item.media-item-' + id).find('.file-image-languages').text(
                            data.translations.map(function (translation) {
                                return translation.locale;
                            }).join(', ')
                        );

                        hideTranslationDeleteButton();
                    });

                    /* Función de retrollamada para mostrar mensaje de error */
                    translationDeleteButton.on('delete-model-error', function (e, response) {
                        toastr.error('La traducción no fue eliminada', 'ERROR!');
                    });

                    showTranslationDeleteButton(languageDeleteRoutes[lang]);
                } else {
                    hideTranslationDeleteButton();
                }
            }

            modal.find('select[name=status]').val(response.status);
        });
    }
})($);