(function ($) {
    /* Variables para mantener DRY */
    var selectAreaClass = "selection-area",
        selectableMediaClass = "selectable-media",
        mediaPageClass = "media-page",
        mediaItemClass = "media-item",
        mediaActionsClass = "media-actions",
        selectedClass = "selected",
        mediaDropzoneClass = "gallery-items",
        mediaDropzoneCorrectClass = "drop-item-correct";

    /**
     * Funciones de interactividad de selección
     * var {Selection}
     */
    const selection = Selection.create({
        class: selectAreaClass,
        startThreshold: 0,
        disableTouch: false,
        mode: 'cover',
        singleClick: false,
        selectables: [`.${selectableMediaClass} div.${mediaItemClass}, .${selectableMediaClass} div.${mediaPageClass}`],
        startareas: [`.${selectableMediaClass}`],
        boundaries: ['.content'],
        selectionAreaContainer: 'body',
        scrollSpeedDivider: 10
    }).on('start', ({ inst, selected, oe }) => {
        if (!isNeedleInHaystack(oe.target, inst.getSelection())) {
            /* Remover la clase si el usuario no está presionando CRTL o ⌘ */
            if (!oe.ctrlKey && !oe.metaKey) {

                /* Deseleccionar todos los elementos */
                for (const el of selected) {
                    el.classList.remove(`${selectedClass}`);
                    inst.removeFromSelection(el);
                }

                /* Remover selección anterior */
                inst.clearSelection();
            }
        }
    }).on('move', ({ oe, inst, selected, changed: { removed, added } }) => {
        if (!isNeedleInHaystack(oe.target, inst.getSelection())) {
            // Add a custom class to the elements that where selected.
            for (const el of added) {
                el.classList.add(`${selectedClass}`);
            }

            // Remove the class from elements that where removed
            // since the last selection
            for (const el of removed) {
                el.classList.remove(`${selectedClass}`);
            }
        }
    }).on('stop', ({ oe, inst }) => {
        if (!isNeedleInHaystack(oe.target, inst.getSelection())) {
            inst.keepSelection();
        }
    });

    /*
      Función privado para la búsqueda de elementos
    */
    function isNeedleInHaystack(needle, haystack) {
        var rawEl = $(needle),
            ancestors = rawEl.parents(`div.${mediaPageClass},div.${mediaItemClass}`),
            hasRightAncestor = ancestors.length > 0,
            actions,
            isMediaItem,
            el;

        /*
          Establecer cuál elemento revisar. Si tiene ancestros válidos,
          usar el primero
        */
        if (hasRightAncestor) {
            el = ancestors.first();
        } else {
            el = rawEl;
        }

        isMediaItem = el.hasClass(`${mediaPageClass}`) || el.hasClass(`${mediaItemClass}`);

        /* Sólo ejecutar si es una clase de media */
        if (isMediaItem) {
            /* Encontrar el elemento con los datos */
            actions = el.find(`.${mediaActionsClass}`);

            /* Buscar en el pajar */
            for (let i = 0; i < haystack.length; i++) {
                let hel = $(haystack[i]);

                if (hel.find(`.${mediaActionsClass}`).data("media") == actions.data("media")) {
                    return true;
                }
            }
        }

        /* No lo encontró */
        return false;
    }

    /**
     * Funciones de interactividad de drag & drop
     * var {Interactable}
     */
    const draggable = interact(`div.${selectableMediaClass} div.${mediaPageClass}, div.${selectableMediaClass} div.${mediaItemClass}`).draggable({
        autoScroll: true,
        onstart: function (e) {
            let target = e.target;
            if (!target.classList.contains(`${selectedClass}`)) {
                /* Eliminar la selección anterior */
                for (element of selection.getSelection()) {
                    element.classList.remove(`${selectedClass}`);
                }

                /* Limpiar selección anterior de ayuda */
                selection.clearSelection();

                /* Originalmente no estaba seleccionado */
                target.classList.add(`${selectedClass}`);

                /* Añadir a selección */
                selection.select(target);

                /* Guardar la selección */
                selection.keepSelection();
            }
        },
        onmove: function (e) {
            let target = e.target,
                /* Obtener coordenadas */
                x = (parseFloat(target.getAttribute('data-x')) || 0) + e.dx,
                y = (parseFloat(target.getAttribute('data-y')) || 0) + e.dy;
            draggables = selection.getSelection();

            /* Cancelar el proceso de selección si ya están seleccionados */
            if (draggables.length > 0) {
                selection.cancel();
            }

            /* Trasladar elementos seleccionados */
            for (element of draggables) {
                element.style.webkitTransform =
                    element.style.transform =
                    `translate(${x}px, ${y}px)`;
            }

            /* Establecer los atributos en el objeto, para próximas traslaciones */
            target.setAttribute('data-x', x);
            target.setAttribute('data-y', y);
        },
        onend: function (e) {
            let target = e.target,
                draggables = selection.getSelection();

            /* Deshacer traslación */
            for (element of draggables) {
                element.style.webkitTransform =
                    element.style.transform =
                    'none';
            }

            /* Resetear valores de coordenadas */
            target.setAttribute('data-x', 0);
            target.setAttribute('data-y', 0);
        }
    });

    const mediaDropzone = interact(`.${mediaDropzoneClass}`).dropzone({
        accept: `div.${mediaPageClass},div.${mediaItemClass}`,
        ondragenter: function (event) {
            /* Añadir clase al objeto */
            event.target.classList.add(mediaDropzoneCorrectClass);
        },
        ondragleave: function (event) {
            /* Remover clase al objeto */
            event.target.classList.remove(mediaDropzoneCorrectClass);
        },
        ondropdeactivate: function (event) {
            /* Remover clase al objeto */
            event.target.classList.remove(mediaDropzoneCorrectClass);
        },
        ondrop: function (event) {
            /*
                Activar o desactivar todos los seleccionados.

                Si el seleccionado ya estaba en la galería, será removido
            */
            $(selection.getSelection()).each(function () {
                $(this).find(`.${mediaActionsClass}`).click();
            });
        }
    });
})($);