(function ($) {
    /* Elementos de vista previa de imágen en galería */
    var els = $('.gallery-items-preview'),
    /* Elementos de pestañas reordenables para galerías */
        sortableGalleryTabs = $('.nav-tabs.sortable-tabs.gallery-tabs'),
        /* Variables para mantener el código DRY */
        dropzoneTranslations = {
            dictDefaultMessage: "Suelte archivos aquí para cargar"
        };

    /* Verificar que existen las vistas previas */
    if(els.length > 0){
        els.each(function(i){
            new Sortable(this, {
                swapThreshold: 1,
                animation: 150,
                ghostClass: 'drag-active',
                dataIdAttr: 'data-id',
                store: {
                    /**
                     * Get the order of elements. Called once during initialization.
                     * @param   {Sortable}  sortable
                     * @returns {Array}
                     */
                    get: function (sortable) {
                        var order = localStorage.getItem(sortable.options.group.name);
                        return order ? order.split('|') : [];
                    },

                    /**
                     * Save the order of elements. Called onEnd (when the item is dropped).
                     * @param {Sortable}  sortable
                     */
                    set: function (sortable) {
                        var order = sortable.toArray();

                        $.ajax({
                            type: 'PUT',
                            url: sortable.el.dataset['route'],
                            data: JSON.stringify(order),
                            contentType: 'json',
                            headers: {
                                'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function (response) {
                                console.log(response);
                            },
                            error:  function (xhr, ajaxOptions, thrownError) {}
                        });
                    }
                }
            });
        });
    }

    /* Verificar que existen las galerías reordenables */
    if(sortableGalleryTabs.length > 0){
        new Sortable(sortableGalleryTabs.get(0), {
            swapThreshold: 1,
            animation: 150,
            dataIdAttr: 'data-id',
            store: {
                /**
                 * Get the order of elements. Called once during initialization.
                 * @param   {Sortable}  sortable
                 * @returns {Array}
                 */
                get: function (sortable) {
                    var order = localStorage.getItem(sortable.options.group.name);
                    return order ? order.split('|') : [];
                },

                /**
                 * Save the order of elements. Called onEnd (when the item is dropped).
                 * @param {Sortable}  sortable
                 */
                set: function (sortable) {
                    var order = sortable.toArray();

                    $.ajax({
                        type: 'PUT',
                        url: sortable.el.dataset['route'],
                        data: JSON.stringify(order),
                        contentType: 'json',
                        headers: {
                            'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function (response) {
                            console.log(response);
                        },
                        error:  function (xhr, ajaxOptions, thrownError) {}
                    });
                }
            }
        });
    }

    /*
        Zona de carga de archivos en la sección de medios en la vista de página
     */
    Dropzone.options.dropzone = {
        dictDefaultMessage: dropzoneTranslations.dictDefaultMessage,
        success: function (file, response) {
            if (file.status === 'success') {
                let mediaObject = MGCms2019GenerateDomMediafileThumbnail(
                    response,
                    function () {
                        /* Pseudovariable "this" es ligada a "mediaObject" */
                        $('#file-detail-modal').modal('toggle', this);
                    }
                );

                /* Eliminar del espacio de subida */
                this.removeFile(file);

                /* Agregar al contenedor y agregar efecto */
                mediaObject.appendTo('#pagemedia .page-media-container').slideDown();
            }
        },
        error: function (file, response) {
            console.log(response)
        },
        queuecomplete: function () {
            toastr.info('La carga de medios ha terminado', 'INFO');
        }
    };

    /***
     * MEDIAFILES SITE DROPZONE
     */

    Dropzone.options.siteFiles = {
        dictDefaultMessage: dropzoneTranslations.dictDefaultMessage,
        sending: function (file, xhr, formData) {
            formData.append('path', $('#path-file').text())
        },
        complete: function (file) {
            (file.status !== 'error') ? this.removeFile(file) : '';
        },
        success: function (file, response) {
            if (file.status === 'success') {
                let mediaObject = MGCms2019GenerateDomMediafileThumbnail(
                    response,
                    function () {
                        /* Pseudovariable "this" es ligada a "mediaObject" */
                        $('#file-detail-modal').modal('toggle', this);
                    }
                );

                /* Agregar al contenedor y agregar efecto */
                mediaObject.appendTo('#sitemedia').slideDown();
            }
        },
        queuecomplete: function () {
            toastr.info('La carga de medios ha terminado', 'INFO');
        }
    };

    /***
     * MEDIAFILES PARA GALERÍAS
     */

    Dropzone.options.galleryDropzone = {
        dictDefaultMessage: dropzoneTranslations.dictDefaultMessage,
        sending: function (file, xhr, formData) {
            formData.append('path', $('#path-file').text())
        },
        complete: function (file) {
            (file.status !== 'error') ? this.removeFile(file) : '';
        },
        success: function (file, response) {
            if (file.status === 'success') {
                let mediaObject = MGCms2019GenerateGalleryDomMediafileThumbnail(
                    response.model,
                    /* Objeto que contiene la información relevante */
                    $("#load-extra-mediafiles")
                );

                /* Agregar al contenedor y agregar efecto */
                mediaObject.appendTo('#extra-mediafiles').slideDown();

                /* Ejecutar acción */
                mediaObject.find(".media-actions").click();
            }
        },
        queuecomplete: function () {
            toastr.info('La carga de medios ha terminado', 'INFO');
        }
    };

    $(document).ready(function () {
        /* Cargar función a los elementos */
        $('.add-to-gallery, .disabled-image').on('click', MGCms2019AddToGallery);

        $('.card-image-component').on('click', MGCms2019ChangeImageCardComponent);

        $("#load-extra-mediafiles").click(function () {
            /* Variable para mantener contexto */
            var self = $(this);

            $.get(
                self.data('load-url')
            ).done(function (response) {
                /* Ciclar entre archivos */
                for (let i = 0; i < response.data.length; i++) {
                    let mediafile = response.data[i],
                        mediaObject = MGCms2019GenerateGalleryDomMediafileThumbnail(
                            mediafile,
                            self
                        );

                    /* Agregar imagen a contenedor */
                    $("#extra-mediafiles").append(mediaObject);
                }

                /* Cambiar el vínculo a la siguiente página */
                if (response.next_page_url !== null) {
                    self.data("load-url", response.next_page_url);
                } else {
                    self.hide();
                }
            });
        });


        $('body').on('click', '.img-choose', function () {

            var galerry_item = $(this).data('action');
            $('#' + galerry_item).removeClass('disabled-image');
            $('#' + galerry_item).addClass('add-to-gallery');

            var input = '#input-' + $(this).attr('id');
            console.log(input);

            $(input).fadeOut('slow').remove();
            $(this).fadeOut('slow').remove();

        });
    });

    /**
     * Función pública para generar un objeto DOM para thumbnail de objeto Mediafile.
     * Para usar en las secciones de medios en páginas o listado de mediafiles
     *
     * @param       {Object}   data          Objeto con la información que deberá
     *                                       ser ligada al resultado
     * @param       {callable} clickCallback Método a ejecutar al dar click en el
     *                                       objeto. La pseudovariable "this" será
     *                                       ligada al objeto
     * @return      {Element}                Objeto para insertar en el DOM
     */
    function MGCms2019GenerateDomMediafileThumbnail(data, clickCallback) {
        var hasFileType = data.model.hasOwnProperty('type') && data.model.type !== null,
            mediaColumn = $('<div />'),
            mediaObject = $('<div />'),
            mediaImage = $('<div />'),
            mediaType = $('<p />'),
            mediaLanguages = $('<p />');

        /* Agregar propiedades del espacio de lenguajes */
        mediaLanguages.addClass('file-image-languages text-center');
        mediaLanguages.text(data.model.translations.map(function (translation) {
            return translation.locale;
        }).join(', '));

        /* Agregar propiedades la imagen (si lo es...) */
        mediaImage.addClass('file-image');

        if (data.model.is_image) {
            mediaImage.css('background-image', 'url(' + data.model.path + ')');
        } else {
            let mediaIcon = $('<span />').addClass('fiv-viv fiv-size-xl');

            mediaIcon.addClass('fiv-icon-' + data.model.file_extension);
            mediaImage.addClass('text-center');
            mediaImage.append(mediaIcon);
        }

        /* Agregar propiedades a objeto principal */
        mediaObject.addClass('media-item media-item-' + data.model.id);

        if (hasFileType) {
            /* Agregar propiedades del espacio de tipo de archivo */
            mediaType.addClass('file-type type-' + data.model.type.type);
            mediaType.text(data.model.type.type);
        }

        /*
          Agregar información de servidor.

          NOTA: No incluye los índices "target" o "toggle" porque no funcionan al
          añadir dinámicamente. Por eso existe la variable "clickCallback"
        */
        mediaObject.data({
            id: data.model.id,
            route: data.route,
            delete: data.delete,
            update: data.update,
            path: data.model.path,
            type: data.model.type_id,
            lang: data.lang,
            langDeleteRoutes: data['lang-delete-routes']
        });

        /* Aplicar la retrollamada */
        mediaObject.click(clickCallback);

        /* Agregar imagen, espacio de tipo de archivo y espacio de lenguajes a objeto principal */
        if (hasFileType) {
            mediaObject.append(mediaImage, mediaType, mediaLanguages);
        } else {
            mediaObject.append(mediaImage, mediaLanguages);
        }

        /* Añadir tamaño de columna */
        mediaColumn.addClass('col-md-3');

        /* Añadir el objeto */
        mediaColumn.append(mediaObject);

        /* Retornar objeto */
        return mediaColumn;
    }

    /**
     * Función pública para generar un objeto DOM para thumbnail de objeto Mediafile.
     * Para usar en las secciones de edición de galerías
     *
     * @param       {Object}   data          Objeto con la información que deberá
     *                                       ser ligada al resultado
     * @param       {jQuery}   callerButton  Objeto que hace la llamada de carga
     *                                       y que tiene datos esenciales a añadir
     * @return      {Element}                Objeto para insertar en el DOM
     */
    function MGCms2019GenerateGalleryDomMediafileThumbnail(data, callerButton) {
        var divColumn = $("<div />"),
            divMain = $("<div />"),
            divActions = $("<div />"),
            divSelectedOverlay = $("<div />"),
            img = $("<img />"),
            p = $("<p />");

        /* Establecer texto de idiomas */
        p.text(data.translations.map(function (translation) {
            return translation.locale;
        }).join(", "));

        /* Establecer imagen */
        img.attr("src", callerButton.data("add-icon-src"));

        /* Espablecer propiedades de DIV de acciones */
        divActions.addClass("media-actions " + callerButton.data("actions-class"));
        divActions.attr("id", "media-action-" + data.id);
        divActions.data("src", data.path);
        divActions.data("media", data.id);

        /* Espablecer propiedades de capa superficial de selección */
        divSelectedOverlay.addClass("selected-overlay");

        /* Establecer función al clic */
        if (callerButton.data("actions-class").includes("add-to-gallery")) {
            divActions.click(MGCms2019AddToGallery);
        } else if (callerButton.data("actions-class").includes("card-image-component")) {
            divActions.click(MGCms2019ChangeImageCardComponent);
        }

        /* Agregar elementos a DIV de acciones */
        divActions.append(img);
        divActions.append(p);

        /* Establecer apariencia del contenedor */
        divMain.addClass("media-page");
        divMain.css("background-image", "url(" + data.path + ")");

        /* Agregar DIV de acciones a DIV principal */
        divMain.append(divActions);

        /* Agregar DIV de capa superficial de selección a DIV principal */
        divMain.append(divSelectedOverlay);

        /* Añadir columnas */
        divColumn.addClass("col-md-3");

        /* Añadir principal a columna */
        divColumn.append(divMain);

        /* Retornar el objeto */
        return divColumn;
    }

    /**
     * Función externa para aplicar las funciones de selección a
     * las imágenes cargadas
     *
     * @param       {Event} event Evento que el objeto envía
     */
    function MGCms2019AddToGallery(event) {
        var self = $(this);
        var media = self.data('media');

        /* No ejecutar si tiene modo de selección */
        if (!self.hasClass('selected')) {
            if (self.hasClass('add-to-gallery')) {
                var src = self.data('src');
                var html = '';
                self.addClass('disabled-image');
                self.removeClass('add-to-gallery');

                html += '<div class="img-choose" id="media-' + media + '" data-action="media-action-' + media + '" style="background-image: url(' + src + ')">';
                html += '<img src="/cms/images/delete.png" alt="">';
                html += '</div>';

                var input = '<input type="hidden" name="images[]" id="input-media-' + media + '" value="' + media + '">';

                $('.gallery-items').append(html);
                $('.input-images').append(input);
            }
            else {

                $('#media-' + media).fadeOut('easy');
                $('#media-' + media).remove();

                $('#input-media-' + media).fadeOut('easy');
                $('#input-media-' + media).remove();

                self.removeClass('disabled-image');
                self.addClass('add-to-gallery');
            }
        }
    }

    /**
     * Función externa para aplicar las funciones de selección a
     * las imágenes cargadas en el componente Card
     *
     * @param       {Event} event Evento que el objeto envía
     */
    function MGCms2019ChangeImageCardComponent(event) {
        var self = $(this);

        /* No ejecutar si tiene modo de selección */
        if (!self.hasClass('selected')) {
            $('.card-image-component').removeClass('disabled-image');
            self.addClass('disabled-image');

            $('#image-card-component').val(self.data('src'));
        }
    }
})($);
