(function($){
    /* Variables para mantener el código DRY */
    var dropzoneTranslations = {
        dictDefaultMessage: "Suelte archivos aquí para cargar"
    }

    Dropzone.options.fileExcel = {
        dictDefaultMessage: dropzoneTranslations.dictDefaultMessage,
        queuecomplete: function (e) {
            var processedLocation = window.location.href.split('?')[0];
            $.ajax({
                url: processedLocation,
                type: 'get',
                dataType: 'json',
                contentType: 'application/json',
                success: function (data) {
                    $('.zone-item').fadeOut('slow');
                    var html = '';
                    var content = $('#zone-content');
                    var isPrevPageDisabled = (data.prev_page_url == null);
                    var isNextPageDisabled = (data.next_page_url == null);

                    var cutResults = data.last_page > 10;
                    var printedEllipsisLink = false;
                    var resumeLinksAt = (cutResults) ? (data.last_page - 2) : data.last_page;

                    html += '<div class="container">';
                    html += '<table class="table table-striped">';
                    html += '<thead>';
                    html += '<tr>';
                    html += '<th scope="col">#</th>';
                    html += '<th scope="col">API code ID</th>';
                    html += '<th scope="col">Status</th>';
                    html += '<th scope="col">Date</th>';
                    html += '</tr>';
                    html += '</thead>';
                    html += '<tbody>';

                    $.each(data.data, function (index, item) {
                        html += '<tr>';
                        html += '<th scope="row">' + item.id + '</th>';
                        html += '<td>' + item.room_api_code_id + '</td>';
                        html += '<td>' + item.status + '</td>';
                        html += '<td>' + item.date + '</td>';
                        html += '</tr>';
                    });

                    html += '</tbody>';
                    html += '</table>';
                    html += '<ul class="pagination" role="navigation">';

                    if (isPrevPageDisabled) {
                        html += '<li class="page-item disabled" aria-disabled="true" aria-label="pagination.previous">';
                        html += '<span class="page-link" aria-hidden="true">&lsaquo;</span>';
                    } else {
                        html += '<li class="page-item">';
                        html += '<a class="page-link" href="' + data.prev_page_url + '" rel="next" aria-label="pagination.next">&rsaquo;</a>';
                    }

                    html += '</li>';

                    for (var i = 1; i <= data.last_page; i++) {
                        if (i == data.current_page) {
                            html += '<li class="page-item active" aria-current="page"><span class="page-link">' + i + '</span></li>';
                        } else if (cutResults && !printedEllipsisLink && (i > 8)) {
                            html += '<li class="page-item disabled" aria-disabled="true"><span class="page-link">...</span></li>';
                            printedEllipsisLink = true;
                        } else if (cutResults && printedEllipsisLink && (i <= resumeLinksAt)) {
                            continue;
                        } else {
                            html += '<li class="page-item"><a class="page-link" href="' + processedLocation + '?page=' + i + '">' + i + '</a></li>';
                        }
                    }

                    if (isNextPageDisabled) {
                        html += '<li class="page-item disabled" aria-disabled="true" aria-label="pagination.next">';
                        html += '<span class="page-link" aria-hidden="true">&rsaquo;</span>';
                    } else {
                        html += '<li class="page-item">';
                        html += '<a class="page-link" href="' + data.next_page_url + '" rel="next" aria-label="pagination.next">&rsaquo;</a>';
                    }

                    html += '</li>';
                    html += '</ul>';
                    html += '</div>';

                    content.html(html);
                }
            });
        },
        complete: function (file) {
            (file.status !== 'error') ? this.removeFile(file) : '';
        },
        success: function (response) {
            console.log(response)
            alert("Carga Completa");

            /* Modificar el encabezado de la actualización */
            $('#last-availability-update-info').html("Usted acaba de efectuar la actualizaci&oacute;n m&aacute;s reciente");
        },
        error: function (file, error, request) {
            console.log(error);
            alert("Hubo errores al procesar el archivo: " + error.message);
        }
    };
})($);