(function($){
    var mainCodesClassName = "room-api-codes",
        singleCodeClassName = "room-api-code",
        mainOverridesClassName = "room-api-code-overrides",
        singleOverrideClassName = "room-api-code-override",
        mainApiCodesFieldName = "api_id",
        singleApiCodeTempPrefix = "timestamp_",
        mainOverridesFieldName = "overrides",
        inputGroupClassName = 'input-group',
        htmlDataIdentifier = "data-",
        dataApiCodeIdTag = `${htmlDataIdentifier}${singleCodeClassName}-id`,
        /** @var function Método anónimo para cambiar etiqueta de la sobrescritura */
        singleApiCodeChangeAction = function () {
            var self = $(this),
                container = self.parents(`.${singleCodeClassName}`),
                /*
                    Como nada más se establece una sola vez y va a ser buscado,
                    es establecido con "attr" en lugar de "data"

                    https://stackoverflow.com/questions/14038003/jquery-selectors-and-html5-data-attributes-set-dynamically
                */
                id = container.attr(dataApiCodeIdTag);

            $(`.${singleOverrideClassName}[${dataApiCodeIdTag}="${id}"] .input-group-text`).text(self.val());
        },
        /** @var function Método anónimo para eliminar sobrescrituras relacionadas con el código */
        singleApiCodeDeleteAction = function () {
            var self = $(this),
                container = self.parents(`.${singleCodeClassName}`),
                /*
                    Como nada más se establece una sola vez y va a ser buscado,
                    es establecido con "attr" en lugar de "data"

                    https://stackoverflow.com/questions/14038003/jquery-selectors-and-html5-data-attributes-set-dynamically
                */
                id = container.attr(dataApiCodeIdTag);

            $(`.${singleOverrideClassName}[${dataApiCodeIdTag}="${id}"]`).remove();
            container.remove();
        },
        imagePickerMasonryInitializer = function () {
            var thumbnailList = $(this).next('ul.thumbnails');

            thumbnailList.addClass("container-fluid");
            thumbnailList.find("li").addClass("col-3");
            thumbnailList.find("img").addClass("img-fluid");
           
            thumbnailList.imagesLoaded(function(){
                thumbnailList.masonry({
                    itemSelector: "li"
                });
            });
        };

    /**
     * Método para generar el código de DOM de un nuevo código de API.
     * 
     * @param  {Integer}            id         Número identificador
     * @param  {String|undefined}   value      Valor que debe tener el campo escrito
     * @return {JQuery}                        Elemento de JQuery para inyección
     */
    function MGCms2019CreateApiCode(id, value) {
        var container = $('<div />')
                                .addClass(`${singleCodeClassName} input-group mb-3`)
                                /*
                                    Como nada más se establece una sola vez y va a ser buscado,
                                    es establecido con "attr" en lugar de "data"

                                    https://stackoverflow.com/questions/14038003/jquery-selectors-and-html5-data-attributes-set-dynamically
                                */
                                .attr(`${htmlDataIdentifier}${singleCodeClassName}-id`, id),
            inputAppendContainer = $('<div />').addClass('input-group-append'),
            removeButton = $('<button />')
                                .addClass(`btn btn-outline-secondary ${singleCodeClassName}-remove`)
                                .prop('type', 'button')
                                /* El siguiente dato es HTML crudo, para no hacer cambio radical de lógica al cambiar */
                                .html('<i class="fas fa-minus"></i>')
                                .click(singleApiCodeDeleteAction),
            inputField = $('<input />')
                                .addClass('form-control')
                                .prop('type', 'text')
                                .prop('name', `${mainApiCodesFieldName}[${id}]`);

        /* Establecer el valor, si existe */
        if (typeof value == 'undefined') {
            inputField.val(value);
        }

        /* Cambiar texto del alias al cambiarlo en el original */
        inputField.change(singleApiCodeChangeAction);

        /* Establecer jerarquía */
        inputAppendContainer.append(removeButton);
        container.append(inputField, inputAppendContainer);

        return container;
    }

    /**
     * Método para generar el código de DOM de un nuevo envoltorio para sobrescritura de campo.
     * 
     * @param  {Integer}  id         Número identificador
     * @param  {String}   type       Tipo de elemento que deberá envolver
     * @return {JQuery}              Elemento de JQuery para inyección
     */
    function MGCms2019CreateRoomApiOverrideContainer(id, type){
        var container = $('<div />')
                            .addClass(`${singleOverrideClassName} mb-3`)
                            /*
                                Como nada más se establece una sola vez y va a ser buscado,
                                es establecido con "attr" en lugar de "data"

                                https://stackoverflow.com/questions/14038003/jquery-selectors-and-html5-data-attributes-set-dynamically
                             */
                            .attr(`${htmlDataIdentifier}${singleCodeClassName}-id`, id),
            inputPrependContainer = $('<div />').addClass('input-group-prepend'),
            spanRoomApiCodeId = $('<span />').addClass('input-group-text');

        /* Establecer jerarquía */
        inputPrependContainer.append(spanRoomApiCodeId);

        /* Establecer jerarquía especial para tipo de archivo */
        if (type == "file") {
            var inputGroupContainer = $('<div />').addClass('d-block'),
                inputGroup = $('<div />').addClass(inputGroupClassName);

            /* Establecer jerarquía */
            inputGroup.append(inputPrependContainer);
            inputGroupContainer.append(inputGroup);
            container.append(inputGroupContainer);
        } else {
            /* Agregar la clase al contenedor */
            container.addClass(inputGroupClassName);
            container.append(inputPrependContainer);
        }        

        return container;
    }

    /**
     * Método para generar el código de DOM de un nuevo campo para sobrescritura de campo.
     * 
     * @param  {Integer}            id         Número identificador
     * @param  {String}             name       Nombre del campo
     * @param  {String}             type       Tipo de elemento que deberá envolver
     * @param  {Object|undefined}   attributes Propiedades a establecer en el campo
     * @param  {Object|undefined}   options    Opciones a establecer, en caso que el 
     *                                         campo sea de selección, radio o casilla
     * @return {JQuery}              Elemento de JQuery para inyección
     */
    function MGCms2019CreateRoomApiOverrideField(id, name, type, attributes, options){
        var container = MGCms2019CreateRoomApiOverrideContainer(id, type),
            separatedName = name.replace(':', ']['),
            isImagePicker = false,
            result,
            customFileLabel,
            field,
            thumbnailList;

        if (type == 'file') {
            /* Contenedor especial para el tipo "file" */
            result = $('<div />').addClass('custom-file');
            
            customFileLabel = $('<label />')
                                    .addClass('custom-file-label')
                                    .text('Subir archivo');
            
            field = $('<input />').prop('type', 'file');

            /* Establecer jerarquía */
            result.append(field, customFileLabel);

            /* Agregar a grupo de campo */
            container.find(`.${inputGroupClassName}`).append(result);
        } else {
            if(type == 'textarea') {
                field = $('<textarea />');
            } else if (type == 'select' || type == 'image-picker') {
                isImagePicker = (type == 'image-picker');

                field = $('<select />');

                /* Añadir opción vacía */
                field.append(new Option("(Vacío)", ""));
    
                /* Agregar las opciones, si existen */
                if (typeof options == "object" && options !== null) {
                    for (var property in options) {
                        var newOption = $(new Option(options[property], property));

                        if(isImagePicker){
                            newOption.attr("data-img-src", options[property]);
                        }

                        field.append(newOption);
                    }
                }
            } else {
                field = $('<input />').prop('type', 'text');
            }

            /* Asignar para retorno */
            result = field;

            /* Agregar a grupo de campo */
            container.append(result);

            /* Agregar clase extra para inicio de selector */
            if (isImagePicker) {
                result.addClass('image-picker masonry');
                result.imagepicker();

                /* each() trabaja sobre el selector de jQuery */
                result.each(imagePickerMasonryInitializer);
            }
        }

        /* Establecer nombre */
        field.prop('name', `${mainOverridesFieldName}[${id}][${separatedName}]`);

        /* Establecer valores de atributos, si existen */
        if (typeof attributes == "object" && attributes !== null) {
            for (var property in attributes) {
                if (property.toString().indexOf(htmlDataIdentifier) == 0) {
                    /*
                        Es un dato de HTML5.
                        Ya que no se va a volver a modificar y debe ser encontrado en el nodo,
                        es establecido con "attr" en lugar de "data":

                        https://stackoverflow.com/questions/14038003/jquery-selectors-and-html5-data-attributes-set-dynamically
                    */
                    field.attr(property, attributes[property]);
                    
                    /* Ir al siguiente valor */
                    continue;
                }

                /* Propiedad regular. Establecer */
                field.prop(property, attributes[property]);
            }
        }
        
        return container;
    }


    $(document).ready(function () {
        /* Añadir definiciones de API */
        $(`.${mainCodesClassName} .${mainCodesClassName}-add`).click(function () {
            /* Recuperar el contenedor de códigos de API */
            var definitionsContainer = $(this).parents(`.${mainCodesClassName}`).find(`.${mainCodesClassName}-definitions`),
                id = singleApiCodeTempPrefix + (new Date).getTime().toString(),
                newApiCode = MGCms2019CreateApiCode(id),
                overridesContainers = $(`.${mainOverridesClassName}`);
            
            /* Añadir el nuevo elemento al DOM */
            definitionsContainer.append(newApiCode);

            /* Crear nuevos campos en sobrescrituras */
            overridesContainers.each(function () {
                var self = $(this),
                    dataPrefix = `${singleCodeClassName}-`,
                    fieldName = self.data(`${dataPrefix}field-name`),
                    fieldType = self.data(`${dataPrefix}field-type`),
                    fieldAttributes = self.data(`${dataPrefix}field-attributes`),
                    fieldOptions = self.data(`${dataPrefix}field-options`),
                    field = MGCms2019CreateRoomApiOverrideField(id, fieldName, fieldType, fieldAttributes, fieldOptions);

                /* Agregar nuevo campo */
                self.append(field);
            });
        });

        /* Remover definiciones de API */
        $(`.${mainCodesClassName} .${mainCodesClassName}-remove`).click(singleApiCodeDeleteAction);

        /* Al cambiar el texto del código de API, deben cambiar las etiquetas de las sobrescrituras */
        $(`.${mainCodesClassName}-definitions .${singleCodeClassName} input`).change(singleApiCodeChangeAction);

        $('.image-picker.masonry').each(imagePickerMasonryInitializer);
    });
})($);