(function ($) {
    $(document).ready(function(){
        /**
         * Eliminar un registro de la BD
         */
        $('body').on('click', '.delete-model', function (e) {
            e.preventDefault();
            /* Variable para mentener contexto */
            var self = $(this);
            var link = self.attr('href');
            var form = $('#delete-item');
            var method = form.attr('method');
            var useAjax = self.hasClass('delete-model-using-ajax');

            swal({
                title: "¿Quieres eliminarlo?",
                text: "Una vez eliminado, no podrás recuperar el registro",
                icon: "warning",
                buttons: true,
                dangerMode: true
            })
            .then(function (willDelete) {
                /*
                    2019-07-03: Cambiado a ES5, para compatibilidad con IE11.
                    Equivalente a "(willDelete) => {"
                */
                if (willDelete) {
                    form.attr('action', link);
                    if (useAjax) {
                        /*
                            Los eventos 'delete-model-success' y 'delete-model-error'
                            deben ser aplicados por cada modelo
                            */
                        $.ajax({
                            url: link,
                            method: method,
                            data: form.serialize()
                        }).done(function (data) {
                            self.trigger('delete-model-success', data);
                        }).fail(function (response) {
                            self.trigger('delete-model-error', response);
                        });
                    } else {
                        form.submit();
                    }
                }
            });
        });
    });
})($);