(function ($) {
    $(document).ready(function () {
        /*
            Método general para que botones puedan someter formularios por medio de AJAX
         */
        $('input.submit-using-ajax[type=sumbit],a.submit-using-ajax').click(function (e) {
            /* Evitar enviar de forma regular */
            e.preventDefault();

            /* Activar guardado en todos los editores WYSIWYG */
            tinymce.triggerSave();

            /* Buscar el formulario padre */
            var self = $(this),
                parentForm = self.parents('form'),
                successMessage = self.data('on-action-success-message');

            /* Establecer predeterminado en caso de no existir */
            if (
                typeof successMessage !== 'string'
                ||
                successMessage.length < 1
            ) {
                successMessage = 'Acción realizada exitosamente';
            }

            /* Si el formulario existe... */
            if (parentForm.length > 0) {
                let fileInputs = parentForm.find('input[type=file]'),
                    hasFileUpload = (fileInputs.length > 0),
                    formData = (hasFileUpload) ? new FormData(parentForm.get(0)) : parentForm.serialize();

                $.ajax({
                    dataType: 'json',
                    type: parentForm.attr('method'),
                    url: parentForm.attr('action'),
                    data: formData,
                    processData: ((hasFileUpload) ? false : true),
                    contentType: ((hasFileUpload) ? false : 'application/x-www-form-urlencoded; charset=UTF-8'),
                    success: function (data) {
                        /* Verificar que el ID retornado existe */
                        if (data.hasOwnProperty('id')) {
                            /* Iterar en las propiedades */
                            for (var property in data) {
                                /* 2020-03-10: Buscar el campo dentro del formulario enviado, para evitar conflictos */
                                let propertyField = parentForm.find(`[name=${property}]`);
                                /* Establecer si existe */
                                if (propertyField.length > 0) {
                                    if (propertyField.is("input[type=text]") || propertyField.is("input[type=readonly]")) {
                                        /* Sólo establecer los valores que son de texto */
                                        propertyField.val(data[property]);
                                    }

                                    /* Aplicar para retrollamadas */
                                    propertyField.trigger('change');
                                }
                            }
                        }

                        toastr.success('Success', successMessage);

                        /* Activar retrollamada: Definido en cada elemento */
                        self.trigger('on-action-success', data);
                    },
                    error: function (xhr, thrownError) {
                        console.log(xhr, thrownError);
                        toastr.error(xhr, 'Algo salió mal');

                        /* Activar retrollamada de error: Definido en cada elemento */
                        self.trigger('on-action-error', xhr);
                    }
                });
            }
        });
    });
})($);