(function ($) {
    $(document).ready(function () {
        $('.generalTable').DataTable();
        $('.select2').select2();
        $('select.image-picker').imagepicker();

        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-bottom-right",
            "preventDuplicates": false,
            "onclick": null,
        };

        // ----------------------------------+
        //           CREAR PAGINAS           |
        // ----------------------------------+

        $("#title, #slug").on('change', function () {
            var title = $(this).val();
            var url_parent = $('#url_parent').text();

            title = convertToSlug(title);
            $('#slug').val(title);
            $('#perman_link').val(url_parent + title);

        });

        $('#slug').on('change', function () {
            if ($(this).val() === '') {
                $(this).val('/')
            }
        });

        $('#selectdb').on('change', function () {
            $('#changedb').submit();
        });


        $('.carousel').carousel();


        //---------------------------+
        //          DROPDOWNS        |
        //---------------------------+

        $('.dropdown-menu a.dropdown-toggle').on('click', function (e) {
            if (!$(this).next().hasClass('show')) {
                $(this).parents('.dropdown-menu').first().find('.show').removeClass("show");
            }
            var $subMenu = $(this).next(".dropdown-menu");
            $subMenu.toggleClass('show');

            $(this).parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function (e) {
                $('.dropdown-submenu .show').removeClass("show");
            });

            return false;
        });

        //----------------------------+
        //          SAVE MEDIA        |
        //----------------------------+

        $('.tooltip-item').tooltip();


        /** -------------------+
         *        PAGES        |
         */

        // DELETE IMAGES
        $('body').on('click', '.delete-img-room', function (e) {
            e.preventDefault(e);
            var route = $(this).data('route');
            var html = '';

            $.get(route, function (room) {
                console.log(typeof room.gallery);
                var url = '/admin/rooms/' + room.id + '/';
                $('.room-images-wrapper').remove();
                var item = room.gallery;
                for (var index in item) {
                    html += '<div class="col-md-2 room-images-wrapper">';
                    html += '<button class="delete-img-room" type="button" data-route="' + url + index + '"><i class="fa fa-trash"></i></button>';
                    html += '<img src="/' + item[index] + '">';
                    html += '</div>';
                }
                $('.room-images').append(html);
            })
        });

        $('body').on('click', '.delete-img-rest', function (e) {
            e.preventDefault(e);
            var route = $(this).data('route');
            var html = '';

            $.get(route, function (restaurant) {
                console.log(typeof restaurant.menus);
                var url = '/admin/restaurants/' + restaurant.id + '/';
                $('.rest-wrapp').remove();
                var item = restaurant.menus;
                for (var index in item) {
                    html += '<div class="form-group col-md-2 rest-wrapp" id="menus">';
                    html += '<label for="">' + item[index].name + '</label>';
                    html += '<input id="amenity-icon" type="text" class="form-control" name="menus[' + index + '][0]" value="' + item[index].name + '">';
                    html += '<input type="hidden" class="form-control" name="menus[' + index + '][1]" value="' + item[index].path + '">';
                    html += '<input id = "amenity-image" name = "menus[]" type = "file">';
                    html += '<button class="delete-img-rest" type="button" data-route="' + url + index + '"><i class="fa fa-trash"></i></button>';
                    html += '</div>';
                }
                $('.rest-add').append(html);
            })
        });

        /* Función para actualizar los campos de permalink en la página */
        $('form.page-form input[name=perman_link]').on('change', function () {
            $('#link-page').attr('href', $(this).val());
        });

        $('.special-form').on('submit', function (e) {
            e.preventDefault();
        });

        /** --------------------------+
         *           AMENITIES        |
         */

        $('#amenity-icon').on('change', function () {
            $('#amenity-image').val('');
        });

        $('#amenity-image').on('change', function () {
            $('#amenity-icon').val('');
            $('#amenity-image').prop('checked', false);
        });


        /** --------------------------+
         *           AMENITIES        |
         */


        $('#add-image').on('click', function (e) {
            var input = '<input name="gallery[]" type="file" class="img-item">';
            $('#gallery-room').append(input)
        });


        /** --------------------------+
         *           RESTAURANT        |
         */


        $('#add-menus').on('click', function (e) {
            var inputWrapper = $('<div />'),
                input = $('<input />'),
                label = $('<label />');

            /* Añadir clases a wrapper */
            inputWrapper.addClass('custom-file');

            /* Añadir propiedades a input */
            input
                .attr('type', 'file')
                .attr('name', 'menus[]')
                .attr('lang', 'es')
                .addClass('custom-file-input');

            /* Añadir callbacks */
            input.on('change', function () {
                let fileName = $(this).val().split("\\").pop();
                $(this).siblings("label.custom-file-label").addClass("selected").html(fileName);
            });

            /* Añadir propiedades a label */
            label
                .addClass('custom-file-label')
                .html('Selecciona men&uacute;');

            /* Llenar wrapper */
            inputWrapper
                .append(input)
                .append(label);

            /* Añadir al espacio de menús */
            $('#menus')
                .append(inputWrapper)
                .append('<br /><br />');
        });

        /** ------------------------+
         *        HORARIOS RESTAURANTS       |
         */

        $('#add-horarios').on('click', function (e) {
            e.preventDefault();

            var html = '';

            html += '<div class="row col-md-12">';
            html += '<div class="form-group col-md-3">';
            html += '<label>Servicio EN</label>';
            html += '<input class="form-control" name="servicio[]" type="text" value="">';
            html += '</div>';
            html += '<div class="form-group col-md-3">';
            html += '<label>Servicio ES</label>';
            html += '<input class="form-control" name="servicio_es[]" type="text" value="">';
            html += '</div>';
            html += '<div class="form-group col-md-3">';
            html += '<label>Abierto</label>';
            html += '<input class="form-control" name="open[]" type="time" value="">';
            html += '</div>';
            html += '<div class="form-group col-md-3">';
            html += '<label>Cerrado</label>';
            html += '<input class="form-control" name="close[]" type="time" value="">';
            html += '</div>';
            html += '</div>';

            $('.horarios').append(html);

        });

        /** ------------------------+
         *        DATEPICKER        |
         */

        $('.date-picker').daterangepicker({
            locale: {
                format: 'DD-MM-YYYY'
            },
            autoApply: true,

        });


        $('.date-single').daterangepicker({
            locale: {
                format: 'YYYY-MM-DD'
            },
            startDate: Date.now(),
            autoApply: true,
            singleDatePicker: true,

        });

        /** ------------------------+
         *        RECIPIENTS        |
         */

        $('#add-recipient').on('click', function (e) {
            e.preventDefault();

            var html = '';

            html += '<div class="form-group col-md-6">';
            html += '<label>email:</label>';
            html += '<input class="form-control" name="email[]" type="email" value="">';
            html += '</div>';
            html += '<div class="form-group col-md-6">';
            html += '<label>name:</label>';
            html += '<input class="form-control" name="user[]" type="text" value="">';
            html += '</div>';

            //html += '<br>';
            //html += '<input class="form-control" required="" name="recipients[]" type="email" value="">';

            $('.recipients').append(html);

        });

        /** ------------------------+
         *        RECIPIENTS BCC    |
         */
        $('#add-recipient-bcc').on('click', function (e) {
            e.preventDefault();

            var html = '';

            html += '<div class="form-group col-md-6">';
            html += '<label>email:</label>';
            html += '<input class="form-control" name="email_bcc[]" type="email" value="">';
            html += '</div>';
            html += '<div class="form-group col-md-6">';
            html += '<label>nombre:</label>';
            html += '<input class="form-control" name="user_bcc[]" type="text" value="">';
            html += '</div>';

            //html += '<br>';
            //html += '<input class="form-control" required="" name="recipients[]" type="email" value="">';

            $('.recipients-bcc').append(html);

        });

        /** ------------------------+
         *        CAPACIDAD HABITACIONES       |
         */
        $('#add-capacity').on('click', function (e) {
            e.preventDefault();

            var html = '';

            html += '<div class="row col-md-12">';
            html += '<div class="form-group col-md-2">';
            html += '<label>Capacity<span class="badge badge-info"></span></label>';
            html += '<input class="form-control" name="capacity[]" type="text" value="">';
            html += '</div>';
            html += '<div class="row col-md-5">'
            html += '<h3>Si:</h3>'
            html += '<div class="form-group col-md-4">',
                html += '<label>Adultos</label>';
            html += '<input class="form-control" name="adults[]" type="text" value="">';
            html += '</div>';
            html += '<div class="form-group col-md-4">';
            html += '<label>Niños</label>'
            html += '<input class="form-control" name="childrens[]" type="text" value="">'
            html += '</div>';
            html += '</div>';
            html += '<div class="row col-md-5">'
            html += '<h3>No:</h3>'
            html += '<div class="form-group col-md-4">',
                html += '<label>Adultos</label>';
            html += '<input class="form-control" name="adults_n[]" type="text" value="">';
            html += '</div>';
            html += '<div class="form-group col-md-4">';
            html += '<label>Niños</label>'
            html += '<input class="form-control" name="childrens_n[]" type="text" value="">'
            html += '</div>';
            html += '</div>';
            html += '</div>';


            $('.capacities').append(html);

        });

        /** ---------------------------+
         *        LLAMADAS AJAX        |
         */

        $.ajaxSetup({
            headers: {
                'X-CSRF-Token': $('meta[name="_token"]').attr('content')
            }
        });

        $(document).ajaxStart(function () {
            $('#ajax-load').css("display", 'block');
        }).ajaxStop(function () {
            $('#ajax-load').css("display", 'none');
        });

        $('.galleries-nestable').nestable({
            maxDepth: 1,
            group: 1,

            callback: function (el) {
                console.log($('meta[name="csrf-token"]').attr('content'));

                $.ajax({
                    type: 'PUT',
                    url: el.data('route'),
                    data: JSON.stringify(el.nestable('serialize')),
                    contentType: 'json',
                    headers: {
                        'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (response) {
                        console.log(response);
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        // console.log(xhr.status);
                        // console.log(thrownError);
                    }
                });
            }
        });


        $('.cards-nestable').nestable({
            maxDepth: 1,
            group: 1,

            callback: function (el) {
                console.log(el.data('url'));
                $.ajax({
                    type: 'PUT',
                    url: el.data('url'),
                    data: JSON.stringify(el.nestable('serialize')),
                    contentType: 'json',
                    headers: {
                        'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (response) {
                        swal('Modificado correctamente');
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        // console.log(xhr.status);
                        // console.log(thrownError);
                    }
                });
            }
        });


        /** ----------------------------+
         *        CREATE BANNERS        |
         */

        $('.lang-banner').on('change', function () {

            /**
             * Primero destruimos el select2 que tiene las url de las paginas
             */
            var select = $('#select-url'); // elemento del DOM
            var plugin = $('.select2').select2(); //instancia del plugin select2
            plugin.select2('destroy'); // Destruccion del plugin
            select.find('option').remove(); // Eliminamos los option que tiene el select


            var lang = $(this).val(); //valor del select
            var route = $(this).data('route'); // valor del data-route
            var html = '';
            route = route.slice(0, -2) + lang; // remplazamos los ultimos dos caracteres del lenguaje y agregamos el valor que se selecciono

            /**
             * Llamada ajax para traer las paginas en el lenguaje seleccionado
             */
            $.get(route, function (response) {
                $.each(response, function (id, name) {

                    html += '<option value="' + id + '"> ' + name + ' </option>';

                });
                html += '<option value="" selected></option>'; //valor seleccionado por defecto

                select.append(html);

                plugin.select2();
            })
        });

        /**
         * Metodo para borrar url
         */

        $('.select2').on('change', function () {
            var select = $('.static-url');

            if (!select.hasClass('active'))
                select.val('');

        });

        $('.static-url').on('change', function () {
            $(this).addClass('active');
            $('.select2').val('');
            $('.select2').trigger('change');
            $(this).removeClass('active');
        });
    });

    function convertToSlug(text) {
        var trimmed = $.trim(text);
        $slug = trimmed.replace(/[^a-z0-9-]/gi, '-').replace(/-+/g, '-').replace(/^-|-$/g, '');
        return $slug.toLowerCase();
    }
})($);

// ----------------------------------+
//           Call To Action          |
// ----------------------------------+
 
$(function(){
    $( document ).on( 'click', '.bookingcta', function(){
    var val = $(this).val();
        //Revisa en que status está el checkbox y controlalo según lo //desees
        if( $( this ).is( ':checked' ) ){
        }
    });
});

$(function () {
    $(document).on("click", ".llamadacta", function () {
      var val = $(this).val();
      //Revisa en que status está el checkbox y controlalo según lo //desees
      if ($(this).is(":checked")) {
        var html = "";
        console.log((val = 1));
        html += '<div class="row" id="tel-remove">'
        html += '<div class="form-group col-md-4">';
        html +=
          '<input class="" name="numbertel" type="text" placeholder="Teléfono" value="">';
        html += "</div>";
  
        html += '<div class="form-group col-md-4">';
        html +=
          '<input class="" name="numbertel_es" type="text" placeholder="Teléfono ES" value="">';
        html += "</div>";
        html += "</div>";
  
        $(".callnumber").append(html);
      }
    });
  });

  $(function () {
    $(document).on("click", ".linkcta", function () {
      var val = $(this).val();
      //Revisa en que status está el checkbox y controlalo según lo //desees
      if ($(this).is(":checked")) {
        var html = "";
        console.log((val = 1));
  
        html += '<div class="row" id="name-remove">';
        html += '<div class="form-group col-md-2"><img src="/cms/images/lang/united-states-of-america.png" alt="EN"> CTA_EN';
        html +=
          '<input class="" name="namecta" type="text" placeholder="CTA" value="">';
        html += "</div>";
  
        html += '<div class="form-group col-md-2"><img src="/cms/images/lang/united-states-of-america.png" alt="EN"> LINK_EN';
        html +=
          '<input class="" name="link" type="text" placeholder="link" value="">';
        html += "</div>";
  
        html += '<div class="form-group col-md-2"><img src="/cms/images/lang/mexico.png" alt="ES"> CTA_ES';
        html +=
          '<input class="" name="namecta_es" type="text" placeholder="CTA ES" value="">';
        html += "</div>";
  
        html += '<div class="form-group col-md-2"><img src="/cms/images/lang/mexico.png" alt="ES"> LINK_ES';
        html +=
          '<input class="" name="link_es" type="text" placeholder="link" value="">';
        html += "</div>";
        html += "</div>";
  
        $(".callnumber").append(html);
      }
    });
  });
  