/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */
window.Vue = require('vue');


require('./bootstrap');
require('jquery-autocomplete');
require('sweetalert');
require('moment');
require('daterangepicker');
require('datatables.net');
require('datatables.net-bs4');
window.Dropzone = require('dropzone');
window.toastr = require('toastr');
window.Sortable = require('sortablejs').Sortable;
window.interact = require('interactjs');
window.Selection = require('@simonwep/selection-js');
window.Masonry = require('masonry-layout');
window.imagesLoaded = require('imagesloaded');
window.jQueryBridget = require('jquery-bridget');

/* Establecer Masonry como plugin de jQuery */
window.jQueryBridget('masonry', window.Masonry, window.$);

/* Establecer imagesLoaded como plugin de jQuery */
window.jQueryBridget('imagesLoaded', window.imagesLoaded, window.$);

require('./base/adminlte.min.js');
require('./custom/columns.js');
require('nestable-fork');
require('trumbowyg');
require('select2');
require('select2/dist/js/i18n/en');
require('select2/dist/js/i18n/es');
require('image-picker');
require('./custom/settings.js');
require('./custom/jquery.simple-dtpicker.js');
require('./base/adminCustom.js');
require('./base/apiCodeOverrides.js');
require('./base/ajaxFormSubmit.js');
require('./base/ajaxModelDelete.js');
require('./base/mediaUpdateModal.js');
require('./base/gallery.js');
require('./base/gallerySelectableMedia.js');
require('./base/availabilityXlsUpload.js');
require('tinymce');
require('tinymce/themes/silver/theme');
require('tinymce/plugins/advlist');
require('tinymce/plugins/autolink');
require('tinymce/plugins/lists');
require('tinymce/plugins/link');
require('tinymce/plugins/image');
require('tinymce/plugins/charmap');
require('tinymce/plugins/print');
require('tinymce/plugins/preview');
require('tinymce/plugins/anchor');
require('tinymce/plugins/textcolor');
require('tinymce/plugins/searchreplace');
require('tinymce/plugins/visualblocks');
require('tinymce/plugins/code');
require('tinymce/plugins/fullscreen');
require('tinymce/plugins/insertdatetime');
require('tinymce/plugins/media');
require('tinymce/plugins/table');
require('tinymce/plugins/paste');
require('tinymce/plugins/code');
require('tinymce/plugins/help');
require('tinymce/plugins/wordcount');
