<?php
/**
* Archivo de constantes para definir en el sistema. Es posible recuperarlos con Config::get('constants.site<id interna de sitio>.<variable>') Ej.: Config::get('constants.site1.api.providers.PriceTravel.hotelId');
*/
return [
    'site1' => [
        'api' => [
            'default' => 'PriceTravel',
            'providers' => [
                'PriceTravel' => [
                    'hotelId' => '000000',
                    'credentials' => [
                        'es' => [
                            'dummy.es',
                            '123456',
                        ],
                        'en' => [
                            'dummy.en',
                            '123456',
                        ]
                    ],
                    'hostDeepLinks' => [
                        // 'es' => url('/') . '/reservar/detalles-reservacion',
                        // 'en' => url('/') . '/book/reservation-details',
                    ],
                ],
            ],
        ],
        'BlogUrl' => [
            // 'es' => url('/') . '/blog/es/feed/',
            // 'en' => url('/') . '/blog/feed/',
        ],
        'Mailchimp' => [
            'credentials' => ['marival', '123456'],
            'list_id' => [
                'es' => '0000000000',
                'en' => '0000000000'
            ]
        ],
        'google' => [
            'site_key' => env('GOOGLE_RECAPTCHA_SITE_KEY'),
            'api_secret' => env('GOOGLE_RECAPTCHA_API_SECRET')
        ],
    ],
];
