<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCtaToSpecialTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('special_translations', function (Blueprint $table) {
            /** 
         * Añade campo de call to action para el manejo
         * de las promociones, peromitirá elegir entre mostrar booking o
         * llamada a la acción en la promoción.
         */
            $table->json('cta')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('special_translations', function (Blueprint $table) {
            /** 
             * Elimina el campo añadido al hacer rollback
             */
            $table->dropColumn('cta');
        });
    }
}
