<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveRoomApiCodeIdDefaultFromAvailabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    
    {
        if (Schema::hasTable('availabilities')) {
            Schema::table('availabilities', function (Blueprint $table) {
                /* Quitar el índice, para poder cambiar el campo */
                $table->dropForeign(['room_api_code_id']);

                $table->unsignedBigInteger('room_api_code_id')
                    ->nullable(false)
                    ->change(); /* Remover predeterminado original */

                /* Volver a crear el índice */
                $table->foreign('room_api_code_id')->references('id')->on('room_api_codes')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('availabilities')) {
            Schema::table('availabilities', function (Blueprint $table) {
                /* Quitar el índice, para poder cambiar el campo */
                $table->dropForeign(['room_api_code_id']);

                $table->unsignedBigInteger('room_api_code_id')
                    ->nullable()
                    ->default(null)
                    ->change(); /* Remover predeterminado original */

                /* Volver a crear el índice */
                $table->foreign('room_api_code_id')->references('id')->on('room_api_codes')->onDelete('cascade');
            });
        }
    }
}
