<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveRoomIdColumnFromAvailabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('availabilities', function (Blueprint $table) {
            /* Eliminar llave foránea antes de campo, si existe */
            $sm = Schema::getConnection()->getDoctrineSchemaManager();
            $indexesFound = $sm->listTableIndexes('availabilities');

            if (array_key_exists("availabilities_room_id_foreign", $indexesFound)) {
                $table->dropForeign(['room_id']);
            }

            $table->dropColumn('room_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('availabilities', function (Blueprint $table) {
            $table->unsignedInteger('room_id')
                ->nullable()
                ->default(null)
                ->after('id');

            $table->foreign('room_id')->references('id')->on('rooms')->onDelete('cascade');
        });
    }
}
