<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DeleteRoomIdDataFromAvailabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /*
            2020-01-27: Vestigial.

            El campo original "room_id" no es compatible con NULL ni tiene
            llave foránea. La siguiente migración eliminará el campo.

            El método down() toma en cuenta que down() en la migración siguiente
            está creando "room_id" con llave foránea y valor NULL predeterminado
        */
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::update('UPDATE
            `availabilities`,
            (
                SELECT DISTINCT
                    `availabilities`.`id`,
                    `first_room_api_codes`.`room_id`
                FROM
                        (SELECT MIN(`room_api_codes`.`id`) AS `id`, `room_api_codes`.`room_id` FROM `room_api_codes` GROUP BY `room_api_codes`.`room_id`) AS `first_room_api_codes`
                    INNER JOIN
                        `availabilities`
                    ON 
                        `first_room_api_codes`.`id` = `availabilities`.`room_api_code_id`
            ) AS `room_ids`
        SET
            `availabilities`.`room_id` = `room_ids`.`room_id`
        WHERE
            (`availabilities`.`id` = `room_ids`.`id`)
    ');
    }
}
