<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveRoomIdDefaultFromAvailabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /*
            2020-01-27: Vestigial.

            El campo original "room_id" no es compatible con NULL ni tiene
            llave foránea. La siguiente migración eliminará el campo.

            El método down() toma en cuenta que down() en las próximas migraciones
            está creando "room_id" con llave foránea y valor NULL predeterminado
        */
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('availabilities')) {
            Schema::table('availabilities', function (Blueprint $table) {
                /* Quitar el índice, para poder cambiar el campo */
                $table->dropForeign(['room_id']);

                $table->unsignedInteger('room_id')
                    ->nullable(false)
                    ->change(); /* Remover predeterminado original */

                /* Volver a crear el índice */
                $table->foreign('room_id')->references('id')->on('rooms')->onDelete('cascade');
            });
        }
    }
}
