<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InsertRoomApiCodeIdValuesIntoAvailabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /*
            Poblar la tabla con los valores existentes desde los códigos de API

            MIN() no hace más que retornar el ID más antiguo que se apega a las condiciones.
            Solamente está usado para que no aparezca como "non-aggregate"
            bajo el modo "only_full_group_by"
        */
        DB::update('UPDATE
            `availabilities`,
            (
                SELECT DISTINCT
                    `availabilities`.`id`,
                    `first_room_api_codes`.`id` AS `room_api_code_id`
                FROM
                        (SELECT MIN(`room_api_codes`.`id`) AS `id`, `room_api_codes`.`room_id` FROM `room_api_codes` GROUP BY `room_api_codes`.`room_id`) AS `first_room_api_codes`
                    INNER JOIN
                        `availabilities`
                    ON 
                        `first_room_api_codes`.`room_id` = `availabilities`.`room_id`
            ) AS `room_api_code_ids`
        SET
            `availabilities`.`room_api_code_id` = `room_api_code_ids`.`room_api_code_id`
        WHERE
            (`availabilities`.`id` = `room_api_code_ids`.`id`)
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /* Remover los valores de códigos de API de la tabla */
        DB::update('UPDATE
            `availabilities`
        SET
            `availabilities`.`room_api_code_id` = NULL
        ');
    }
}
