<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRoomApiCodeIdToAvailabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('availabilities')) {
            Schema::table('availabilities', function (Blueprint $table) {
                $table->unsignedBigInteger('room_api_code_id')
                    ->nullable() /* Establecido para poder crear campo en registros ya establecidos */
                    ->default(null)
                    ->after('room_id');

                $table->foreign('room_api_code_id')->references('id')->on('room_api_codes')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('availabilities', function (Blueprint $table) {
            $table->dropForeign(['room_api_code_id']);

            $table->dropColumn('room_api_code_id');
        });
    }
}
