<?php

use AvengersMG\MGCms2019\App\Cms\Accommodations\Room;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class PurgeNonexistentRoomDataFromAvailabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /** @var int[] IDs de habitaciones en sistema */
        $room_ids = Room::pluck('id')->toArray();

        /* Eliminar los registros que apunten a habitaciones no existentes */
        DB::table('availabilities')
            ->whereNotIn('room_id', $room_ids)
            ->delete();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /*
            2020-01-27: Vestigial. No es posible recuperar información intencionalmente eliminada y sin archivar.
        */
    }
}
