<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRoomDataOverridesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('room_data_overrides')) {
            Schema::create('room_data_overrides', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('room_api_code_translation_id');
                $table->foreign('room_api_code_translation_id')->references('id')->on('room_api_code_translations')->onDelete('cascade');
                $table->string('name');
                $table->unique(['room_api_code_translation_id', 'name']);
                $table->text('data')->nullable()->default(null);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('room_data_overrides');
    }
}
