<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InsertTranslationsIntoRoomApiCodeTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Poblar la tabla con los valores existentes */
        DB::insert('INSERT INTO
            `room_api_code_translations`
                (
                    `room_api_code_id`,
                    `locale`,
                    `thumbnail_mediafile_id`,
                    `created_at`,
                    `updated_at`
                )
                SELECT DISTINCT
                    `room_api_codes`.`id` AS `room_api_code_id`,
                    `room_translations`.`locale`,
                    NULL AS `thumbnail_mediafile_id`,
                    CURRENT_TIMESTAMP() AS `created_at`,
                    NULL AS `updated_at`
                FROM
                            `room_translations`
                        INNER JOIN
                            `room_api_codes`
                        ON
                            `room_api_codes`.`room_id` = `room_translations`.`room_id`
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::table('room_api_code_translations')->truncate();
    }
}
