<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Carbon\Carbon;

class InsertValuesIntoRoomApiCodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Poblar la tabla con los valores existentes */
        DB::insert('INSERT INTO
            `room_api_codes`
                (
                    `room_id`,
                    `api_code`,
                    `created_at`,
                    `updated_at`
                )
            SELECT DISTINCT
                `rooms`.`id` AS `room_id`,
                `rooms`.`api_id`,
                CURRENT_TIMESTAMP() AS `created_at`,
                null as `updated_at`
            FROM `rooms`
            WHERE 
                `rooms`.`api_id` IS NOT NULL
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::update('UPDATE
            `rooms`,
            `room_api_codes`
        SET
            `rooms`.`api_id` = `room_api_codes`.`api_code`
        WHERE
            (`room_api_codes`.`room_id` = `rooms`.`id`)
        ');
    }
}
