<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRoomApiCodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('room_api_codes')) {
            Schema::create('room_api_codes', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('room_id');
                $table->string('api_code')->unique();
                $table->foreign('room_id')->references('id')->on('rooms')->onDelete('cascade');
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('room_api_code_translations')) {
            Schema::create('room_api_code_translations', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('room_api_code_id');
                $table->string('locale')->index();
                $table->unsignedInteger('thumbnail_mediafile_id')->nullable()->default(null);
                $table->foreign('room_api_code_id')->references('id')->on('room_api_codes')->onDelete('cascade');
                $table->foreign('thumbnail_mediafile_id')->references('id')->on('mediafiles')->onDelete('set null');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('room_api_code_translations');
        Schema::dropIfExists('room_api_codes');
    }
}
