<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeForeignConstraintsToSiteUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_user', function (Blueprint $table) {
            /* Eliminar índice foráneo para volver a crear */
            $table->dropForeign(['user_id']);

            /* Volver a crear restricción de usuario */
            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('CASCADE')
                ->onUpdate('CASCADE');

            /* Eliminar índice foráneo para volver a crear */
            $table->dropForeign(['site_id']);

            /* Volver a crear restricción de usuario */
            $table->foreign('site_id')
                ->references('id')
                ->on('sites')
                ->onDelete('CASCADE')
                ->onUpdate('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_user', function (Blueprint $table) {
            /* Eliminar índice foráneo para volver a crear */
            $table->dropForeign(['user_id']);

            /* Volver a crear restricción de usuario */
            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('RESTRICT')
                ->onUpdate('RESTRICT');

            /* Eliminar índice foráneo para volver a crear */
            $table->dropForeign(['site_id']);

            /* Volver a crear restricción de usuario */
            $table->foreign('site_id')
                ->references('id')
                ->on('sites')
                ->onDelete('RESTRICT')
                ->onUpdate('RESTRICT');
        });
    }
}
