<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPriorityColumnToGalleriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('galleries')) {
            Schema::table('galleries', function (Blueprint $table) {
                $table->integer('priority')->nullable()->default(null)->after('is_mobile');
                $table->unique(['page_id', 'priority']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('galleries', function($table) {
            /*
              Esto es necesario porque MySQL tiene un bug: quita el FOREIGN KEY
             */
            $sm = Schema::getConnection()->getDoctrineSchemaManager();
            $indexesFound = $sm->listTableIndexes('galleries');

            if (!array_key_exists("galleries_page_id_foreign", $indexesFound)) {
                $table->index('page_id', 'galleries_page_id_foreign');
            }            
        });

        Schema::table('galleries', function (Blueprint $table) {
            $table->dropUnique('galleries_page_id_priority_unique');
        });
    }
}
