<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class TransferSpecialTranslationNotificationDataToSpecialTranslationNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Fecha y hora del servidor, para uso futuro */
        $now = Carbon::now();

        /* Obtener la información ya creada en las traducciones de los especiales */
        $specialTranslations = DB::table('special_translations')->select('notification_time', 'id')->whereNotNull('notification_time')->get();

        if ($specialTranslations->isNotEmpty()) {
            /* Insertar los valores que están en los datos originales, si hay */
            DB::table('special_translation_notifications')->insert(
                $specialTranslations->map(function ($translation) use ($now) {
                    return [
                        'special_translation_id' => $translation->id,
                        'notification_time' => $translation->notification_time,
                        'created_at' => $now->toDateTimeString(),
                    ];
                })->toArray()
            );
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /* Fecha y hora del servidor, para uso futuro */
        $now = Carbon::now();

        /* Obtener el registro más reciente de las notificaciones */
        $specialNotifications = DB::table('special_translation_notifications')->select('notification_time', 'special_translation_id', 'created_at')->get()->groupBy('special_translation_id');

        if ($specialNotifications->isNotEmpty()) {
            /* Insertar los valores que están en los datos originales, si hay */
            DB::table('special_translations')
                ->setBindings(
                    $specialNotifications->mapWithKeys(function ($itemData, $idemId) {
                        /* Retornar nuevo biding con valor de prioridad */
                        return [
                            "id{$idemId}" => $itemData->sort(function ($a, $b) {
                                return strtotime($a->created_at) > strtotime($b->created_at);
                            })->first()->notification_time,
                        ];
                    })->all()
                )
                ->update([
                    'notification_time' => DB::raw(
                        implode([
                            'CASE `id`',
                            $specialNotifications->keys()->map(function ($itemId) {
                                /* Retornar SQL de caso */
                                return "WHEN {$itemId} THEN :id{$itemId}";
                            })->implode(' '),
                            'ELSE `notification_time` END'
                        ], ' ')
                    )
                ]);
        }
    }
}