<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSpecialTranslationNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('special_translation_notifications', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('special_translation_id');
            $table->dateTime('notification_time');
            $table->timestamp('created_at');
            $table->timestamp('sent_at')->nullable()->default(null);
            $table->foreign('special_translation_id')->references('id')->on('special_translations')->onDelete('cascade');
            $table->unique(['special_translation_id', 'notification_time'], 'unique_special_trans_notif');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('special_translation_notifications');
    }
}