<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAvailabilitiesLogEntriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('availabilities_log_entries', function (Blueprint $table) {
            $table->bigIncrements('id');
            /*
              Este campo no contiene una restricción contra la tabla de usuarios
              para evitar la eliminación de registros o la conversión a NULL.
              En caso que el usuario listado aquí no exista, revisar volcados
              antiguos hasta encontrarlo.
            */
            $table->unsignedBigInteger('user_id');
            $table->string('file_name');
            $table->string('file_size')->nullable();
            $table->string('file_content_type')->nullable();
            $table->timestamp('created_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('availabilities_log_entries');
    }
}
