<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateApiConsumersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('api_consumers')) {
            Schema::create('api_consumers', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('username')->nullable()->unique();
                $table->string('password');
                $table->string('contact_name');
                $table->string('contact_email')->unique();
                $table->timestamps();
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('api_consumers');
    }
}
