<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNullablesToRestaurantTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('restaurant_translations', function (Blueprint $table) {
            $table->string('open')->nullable()->default(null)->change();
            $table->string('close')->nullable()->default(null)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('restaurant_translations', function (Blueprint $table) {
            $table->string('open')->change();
            $table->string('close')->change();
        });
    }
}
