<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteSocialmediaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('site_socialmedia')){
            Schema::create('site_socialmedia', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('site_id');
                $table->unsignedBigInteger('socialmedia_id');
                $table->string('url')->nullable()->default(null);
                $table->timestamps();
                $table->foreign('site_id')
                    ->references('id')->on('sites')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');
                $table->foreign('socialmedia_id')
                    ->references('id')->on('socialmedias')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');
                $table->unique(['site_id', 'socialmedia_id']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_socialmedia');
    }
}
