<?php

use AvengersMG\MGCms2019\App\Cms\Accommodations\RoomTranslation;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddPoblateJsonIntoRoomsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $now = Carbon::now()->toDateTimeString();

        $newCapacitiesPerRoomTranslationId = RoomTranslation::all('id', 'capacity', 'adults', 'childrens')
            ->mapWithKeys(function($translation){
                return [
                    "{$translation->id}" => "[{\"capacidad\": \"{$translation->capacity}\",
                    \"yes\": {\"adultos\": \"{$translation->adults}\", \"ninos\": \"{$translation->childrens}\"},
                    \"no\":   {\"adultos\": \"{$translation->adults}\", \"ninos\": \"{$translation->childrens}\"}
                    }]"
                ];
            });

        /* Ejecutar si hay cambios */
        if ($newCapacitiesPerRoomTranslationId->isNotEmpty()) {
            /* Actualizar todas */
            RoomTranslation::query()
                ->setBindings(
                    array_merge(
                        $newCapacitiesPerRoomTranslationId->mapWithKeys(function ($itemData, $itemId) {
                            return [
                                "id{$itemId}" => $itemData,
                            ];
                        })->all(),
                        $newCapacitiesPerRoomTranslationId->keys()->mapWithKeys(function ($itemId) use ($now){
                            return [
                                "updatedAtId{$itemId}" => $now,
                            ];
                            /* Necesario establecer `updated_at` porque, si no,
                             el sistema lo implementa usando el binding
                             por posiciones */
                        })->all()
                    )
                )
                ->update([
                    'capacities' => DB::raw(
                        implode([
                            'CASE `id`',
                            $newCapacitiesPerRoomTranslationId->keys()->map(function ($itemId) {
                                /* Retornar SQL de caso */
                                return "WHEN {$itemId} THEN :id{$itemId}";
                            })->implode(' '),
                            'ELSE `capacities` END'
                        ], ' ')
                    ),
                    'updated_at' => DB::raw(
                        implode([
                            'CASE `id`',
                            $newCapacitiesPerRoomTranslationId->keys()->map(function ($itemId) {
                                /* Retornar SQL de caso */
                                return "WHEN {$itemId} THEN :updatedAtId{$itemId}";
                            })->implode(' '),
                            'ELSE `updated_at` END'
                        ], ' ')
                    ),
                ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /*
            Desaconsejado hacer RoomTranslation::update(), por lo que hay que
            llamar antes query()
         */
        RoomTranslation::query()->update([
            'capacities' => '[]',
        ]);
    }
}
