<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNullablesFieldsToRoomTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('room_translations')) {
            Schema::table('room_translations', function (Blueprint $table) {

                $table->string('capacity')->nullable()->default(null)->change();
                $table->string('childrens')->nullable()->default(null)->change();
                $table->string('adults')->nullable()->default(null)->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('room_translations', function (Blueprint $table) {
            $table->string('capacity')->change();
            $table->string('childrens')->change();
            $table->string('adults')->change();
        });
    }
}
